/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.strategy.IEquivalentProvider;
import org.eclipse.epsilon.etl.dom.TransformationRule;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;
import org.eclipse.epsilon.etl.strategy.ITransformationStrategy;

public abstract class AbstractTransformationStrategy
implements ITransformationStrategy {
    protected IEquivalentProvider equivalentProvider = this;

    protected Collection<Object> getExcluded() {
        return Collections.emptyList();
    }

    protected List<TransformationRule> getExecutableRules(IEtlContext context) throws EolRuntimeException {
        List<TransformationRule> allRules = context.getModule().getTransformationRules();
        ArrayList<TransformationRule> filtered = new ArrayList<TransformationRule>(allRules.size());
        for (TransformationRule transformRule : allRules) {
            if (transformRule.isAbstract((IEolContext)context) || transformRule.isLazy((IEolContext)context)) continue;
            filtered.add(transformRule);
        }
        return filtered;
    }

    protected List<TransformationRule> getRulesFor(Object source, IEtlContext context) throws EolRuntimeException {
        ArrayList<TransformationRule> rules = new ArrayList<TransformationRule>();
        for (TransformationRule rule : context.getModule().getTransformationRules()) {
            if (rule.isAbstract((IEolContext)context) || !rule.appliesTo(source, context, false)) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public boolean canTransform(Object source) {
        return !this.getExcluded().contains(source);
    }

    @Override
    public void setEquivalentProvider(IEquivalentProvider equivalentProvider) {
        this.equivalentProvider = equivalentProvider;
    }

    @Override
    public IEquivalentProvider getEquivalentProvider() {
        return this.equivalentProvider;
    }
}

