/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.erl.dom.ExtensibleNamedRule;
import org.eclipse.epsilon.etl.dom.IEtlVisitor;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;

public class TransformationRule
extends ExtensibleNamedRule {
    protected Parameter sourceParameter;
    protected List<Parameter> targetParameters = new ArrayList<Parameter>(2);
    protected ExecutableBlock<Boolean> guard;
    protected ExecutableBlock<Void> body;
    protected IEtlContext context;
    protected Boolean isPrimary = null;
    protected Collection<Object> rejected = new HashSet<Object>();
    protected Set<Object> transformedElements = new HashSet<Object>();

    public AST getSuperRulesAst(AST cst) {
        return AstUtil.getChild((AST)cst, (int)85);
    }

    public Parameter getSourceParameter() {
        return this.sourceParameter;
    }

    public void setSourceParameter(Parameter sourceParameter) {
        this.sourceParameter = sourceParameter;
    }

    public ExecutableBlock<Void> getBody() {
        return this.body;
    }

    public void setBody(ExecutableBlock<Void> body) {
        this.body = body;
    }

    public ExecutableBlock<Boolean> getGuard() {
        return this.guard;
    }

    public void setGuard(ExecutableBlock<Boolean> guard) {
        this.guard = guard;
    }

    public List<Parameter> getTargetParameters() {
        return this.targetParameters;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.guard = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)86), (ModuleElement)this);
        this.body = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)67), (ModuleElement)this);
        AST sourceParameterAst = cst.getFirstChild().getNextSibling();
        this.sourceParameter = (Parameter)module.createAst(sourceParameterAst, (ModuleElement)this);
        AST targetParametersAst = sourceParameterAst.getNextSibling();
        CollectionUtil.addCapacityIfArrayList(this.targetParameters, (int)targetParametersAst.getChildCount());
        AST targetParameterAst = targetParametersAst.getFirstChild();
        while (targetParameterAst != null) {
            this.targetParameters.add((Parameter)module.createAst(targetParameterAst, (ModuleElement)this));
            targetParameterAst = targetParameterAst.getNextSibling();
        }
    }

    public boolean isLazy(IEolContext context) throws EolRuntimeException {
        if (this.isLazy == null) {
            this.isLazy = super.isLazy(context) || !(this.sourceParameter.getType(context) instanceof EolModelElementType) && !this.isAbstract(context);
        }
        return this.isLazy;
    }

    public boolean hasTransformed(Object source) {
        return this.transformedElements.contains(source);
    }

    public boolean appliesTo(Object source, IEtlContext context, boolean asSuperRule) throws EolRuntimeException {
        return this.appliesTo(source, context, asSuperRule, true);
    }

    public boolean appliesTo(Object source, IEtlContext context, boolean asSuperRule, boolean checkTypes) throws EolRuntimeException {
        boolean appliesToTypes;
        if (this.hasTransformed(source)) {
            return true;
        }
        if (this.rejected.contains(source)) {
            return false;
        }
        if (!checkTypes) {
            appliesToTypes = true;
        } else {
            boolean ofTypeOnly = !this.isGreedy((IEolContext)context) && !asSuperRule;
            EolType type = this.sourceParameter.getType((IEolContext)context);
            appliesToTypes = ofTypeOnly ? type.isType(source) : type.isKind(source);
        }
        boolean guardSatisfied = true;
        if (appliesToTypes && this.guard != null) {
            guardSatisfied = (Boolean)this.guard.execute((IEolContext)context, new Variable[]{Variable.createReadOnlyVariable((String)this.sourceParameter.getName(), (Object)source), Variable.createReadOnlyVariable((String)"self", (Object)((Object)this))});
        }
        boolean applies = appliesToTypes && guardSatisfied;
        for (ExtensibleNamedRule superRule : this.getSuperRules()) {
            TransformationRule rule = (TransformationRule)superRule;
            if (rule.appliesTo(source, context, true)) continue;
            applies = false;
            break;
        }
        if (!applies) {
            this.rejected.add(source);
        }
        return applies;
    }

    public Collection<?> getAllInstances(IEtlContext context) throws EolRuntimeException {
        return this.getAllInstances(this.sourceParameter, (IEolContext)context, !this.isGreedy((IEolContext)context));
    }

    public void transformAll(IEtlContext context, Collection<Object> excluded, boolean includeLazy) throws EolRuntimeException {
        Collection<?> all = this.getAllInstances(context);
        for (Object instance : all) {
            if (!this.shouldBeTransformed(instance, excluded, context, includeLazy)) continue;
            this.transform(instance, context);
        }
    }

    public Collection<?> transform(Object source, Collection<Object> targets, IEtlContext context) throws EolRuntimeException {
        this.transformedElements.add(source);
        this.executeSuperRulesAndBody(source, targets, context);
        return targets;
    }

    public Collection<?> transform(Object source, IEtlContext context) throws EolRuntimeException {
        if (this.hasTransformed(source)) {
            return context.getTransformationTrace().getTransformationTargets(source, this);
        }
        this.transformedElements.add(source);
        List targets = CollectionUtil.createDefaultList();
        for (Parameter targetParameter : this.targetParameters) {
            EolType targetParameterType = targetParameter.getType((IEolContext)context);
            targets.add(targetParameterType.createInstance());
        }
        context.getTransformationTrace().add(source, targets, this);
        this.executeSuperRulesAndBody(source, targets, context);
        return targets;
    }

    protected void executeSuperRulesAndBody(Object source, Collection<Object> targets_, IEtlContext context) throws EolRuntimeException {
        List targets = CollectionUtil.asList(targets_);
        for (ExtensibleNamedRule rule : this.superRules) {
            TransformationRule superRule = (TransformationRule)rule;
            superRule.transform(source, targets, context);
        }
        Variable[] variables = new Variable[this.targetParameters.size() + 2];
        variables[0] = Variable.createReadOnlyVariable((String)"self", (Object)((Object)this));
        variables[1] = Variable.createReadOnlyVariable((String)this.sourceParameter.getName(), (Object)source);
        int i = 2;
        while (i < variables.length) {
            int offset = i - 2;
            Parameter tp = this.targetParameters.get(offset);
            variables[i] = Variable.createReadOnlyVariable((String)tp.getName(), targets.get(offset));
            ++i;
        }
        this.body.execute((IEolContext)context, variables);
    }

    public String toString() {
        String targetTypes = this.targetParameters.stream().map(Parameter::getTypeName).collect(Collectors.joining(", "));
        return String.valueOf(this.getName()) + " (" + this.sourceParameter.getTypeName() + ") : " + targetTypes;
    }

    public boolean isPrimary(IEtlContext context) throws EolRuntimeException {
        if (this.isPrimary == null) {
            this.isPrimary = this.getBooleanAnnotationValue("primary", (IEolContext)context);
        }
        return this.isPrimary;
    }

    public boolean canTransformExcluded(IEtlContext context) throws EolRuntimeException {
        return this.getBooleanAnnotationValue("excluded", (IEolContext)context, false, true);
    }

    public boolean shouldBeTransformed(Object instance, Collection<Object> excluded, IEtlContext context, boolean overrideLazy) throws EolRuntimeException {
        return !(!overrideLazy && this.isLazy((IEolContext)context) || this.isAbstract((IEolContext)context) || excluded != null && excluded.contains(instance) || !this.appliesTo(instance, context, false));
    }

    public void accept(IEtlVisitor visitor) {
        visitor.visit(this);
    }

    public void dispose() {
        this.rejected = null;
        this.transformedElements = null;
    }
}

