/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl.parse;

import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.parse.EolUnparser;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.dom.IErlVisitor;
import org.eclipse.epsilon.erl.dom.NamedStatementBlockRule;
import org.eclipse.epsilon.erl.dom.Post;
import org.eclipse.epsilon.erl.dom.Pre;

public abstract class ErlUnparser
extends EolUnparser
implements IErlVisitor {
    public String unparse(ErlModule module) {
        return super.unparse((EolModule)module);
    }

    protected void unparseMain() {
        ((ErlModule)this.module).getDeclaredPre().forEach(p -> {
            p.accept(this);
            this.newline();
        });
        this.unparseRules();
        ((ErlModule)this.module).getDeclaredPost().forEach(p -> {
            p.accept(this);
            this.newline();
        });
    }

    protected abstract void unparseRules();

    public void visit(ExecutableBlock<?> executableBlock) {
        IExecutableModuleElement body = executableBlock.getBody();
        if (body instanceof StatementBlock) {
            this.space();
            ((StatementBlock)body).accept((IEolVisitor)this);
        } else if (body instanceof Expression) {
            this.buffer.append(": ");
            ((Expression)body).accept((IEolVisitor)this);
        }
    }

    @Override
    public void visit(Post post) {
        this.unparsePreAndPost("post", post);
    }

    @Override
    public void visit(Pre pre) {
        this.unparsePreAndPost("pre", pre);
    }

    protected void unparsePreAndPost(String label, NamedStatementBlockRule preOrPost) {
        this.unparseAnnotations(preOrPost);
        this.buffer.append(String.valueOf(label) + " ");
        String name = preOrPost.getName();
        if (!StringUtil.isEmpty((String)name)) {
            this.buffer.append(String.valueOf(name) + " ");
        }
        preOrPost.getBody().accept((IEolVisitor)this);
    }

    protected void print(String role, ExecutableBlock<?> executableBlock) {
        if (executableBlock != null) {
            this.newline();
            this.indent();
            this.buffer.append(role);
            this.space();
            executableBlock.accept((IEolVisitor)this);
            this.newline();
        }
    }

    protected void printGuard(ExecutableBlock<Boolean> guardBlock) {
        this.print("guard", guardBlock);
    }
}

