/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl.execute.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class JobBatch
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5469863968982457471L;
    public int from;
    public int to;

    public JobBatch() {
    }

    public JobBatch(int from, int to) {
        this.from = from;
        this.to = to;
    }

    protected JobBatch clone() {
        JobBatch clone;
        try {
            clone = (JobBatch)super.clone();
        }
        catch (CloneNotSupportedException cnsx) {
            throw new UnsupportedOperationException(cnsx);
        }
        clone.from = this.from;
        clone.to = this.to;
        return clone;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JobBatch)) {
            return false;
        }
        JobBatch other = (JobBatch)obj;
        return this.from == other.from && this.to == other.to;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [from=" + this.from + ", to=" + this.to + "]";
    }

    public static List<JobBatch> getBatches(int totalJobs, int chunks) {
        assert (totalJobs >= 1) : "Must have at least one job";
        assert (chunks >= 1) : "Batch size (chunks) must be at least 1";
        int modulo = totalJobs % chunks;
        int division = totalJobs / chunks;
        int batches = modulo > 0 ? 1 + division : division;
        ArrayList<JobBatch> resultList = new ArrayList<JobBatch>(batches);
        int prev = 0;
        int curr = chunks;
        while (curr <= totalJobs) {
            int n = prev;
            prev = curr;
            resultList.add(new JobBatch(n, prev));
            curr += chunks;
        }
        if (batches > 0 && modulo > 0) {
            resultList.add(new JobBatch(totalJobs - modulo, totalJobs));
        }
        assert (resultList.size() == batches) : "Expected number of batches met";
        assert (resultList.get((int)(batches - 1)).to == totalJobs && resultList.get((int)0).from == 0) : "All jobs retained";
        return resultList;
    }

    public <T> List<T> splitToList(T[] arr) {
        return Arrays.asList(this.split(arr));
    }

    public <T> T[] split(T[] arr) {
        return Arrays.copyOfRange(arr, this.from, this.to);
    }

    public <T> List<T> split(List<T> list) {
        return list.subList(this.from, this.to);
    }
}

