/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl.execute;

import java.util.Map;
import org.eclipse.epsilon.common.function.BaseDelegate;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.control.DefaultExecutionController;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.control.ExecutionProfiler;
import org.eclipse.epsilon.erl.execute.control.RuleProfiler;

public class RuleExecutorFactory
extends ExecutorFactory {
    public RuleExecutorFactory() {
        this(null);
    }

    public RuleExecutorFactory(ExecutorFactory parent) {
        super(parent);
        if (parent != null) {
            this.setProfilingEnabled(parent.isProfilingEnabled());
        }
    }

    public void setProfilingEnabled(boolean profile) {
        boolean profilingEnabled = this.isProfilingEnabled();
        if (profile && !profilingEnabled) {
            this.setExecutionController((ExecutionController)new RuleProfiler());
        } else if (!profile && profilingEnabled) {
            this.setExecutionController((ExecutionController)new DefaultExecutionController());
        }
    }

    public void merge(BaseDelegate.MergeMode mode) {
        ExecutorFactory from = (ExecutorFactory)this.getFrom(mode);
        ExecutorFactory to = (ExecutorFactory)this.getTo(mode);
        ExecutionController fromController = from.getExecutionController();
        ExecutionController toController = to.getExecutionController();
        if (fromController instanceof ExecutionProfiler && toController instanceof ExecutionProfiler) {
            ((ExecutionProfiler)toController).mergeExecutionTimes(new Map[]{((ExecutionProfiler)fromController).getExecutionTimes()});
        }
        super.merge(mode);
    }
}

