/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.eol.util.IdentityBasedWeakReference;

public class Cache<K, V> {
    protected ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    protected Map<IdentityBasedWeakReference, V> map = new HashMap<IdentityBasedWeakReference, V>();
    protected Thread cleanUpThread;

    public Map<IdentityBasedWeakReference, V> getMap() {
        return this.map;
    }

    protected Thread createCleanUpThread() {
        Thread th = new Thread(() -> {
            while (!this.map.isEmpty() && !Thread.currentThread().isInterrupted()) {
                try {
                    Reference<Object> reference = this.referenceQueue.remove();
                    if (!(reference instanceof IdentityBasedWeakReference)) continue;
                    Map<IdentityBasedWeakReference, V> map = this.map;
                    synchronized (map) {
                        this.map.remove(reference);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        th.setDaemon(true);
        th.setName(String.valueOf(this.getClass().getName()) + "-cleanup");
        return th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        Map<IdentityBasedWeakReference, V> map = this.map;
        synchronized (map) {
            return this.map.get(new IdentityBasedWeakReference(key, this.referenceQueue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        IdentityBasedWeakReference reference = new IdentityBasedWeakReference(key, this.referenceQueue);
        Map<IdentityBasedWeakReference, V> map = this.map;
        synchronized (map) {
            if (!this.map.containsKey(reference)) {
                this.map.put(reference, value);
                if (this.map.size() == 1 && this.cleanUpThread != null && !this.cleanUpThread.isAlive()) {
                    this.cleanUpThread = this.createCleanUpThread();
                    this.cleanUpThread.start();
                }
            }
            return value;
        }
    }

    public int size() {
        return this.map.size();
    }

    public void dispose() {
        if (this.cleanUpThread != null) {
            this.cleanUpThread.interrupt();
            this.cleanUpThread = null;
        }
        this.map.clear();
    }
}

