/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.math.BigDecimal;

public class NumberUtil {
    public static Number multiply(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return NumberUtil.map(n1).multiply(NumberUtil.map(n2));
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            return n1.doubleValue() * n2.doubleValue();
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(n1.floatValue() * n2.floatValue());
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return n1.longValue() * n2.longValue();
        }
        return n1.intValue() * n2.intValue();
    }

    private static BigDecimal map(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.toString());
    }

    public static Number add(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return NumberUtil.map(n1).add(NumberUtil.map(n2));
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            return n1.doubleValue() + n2.doubleValue();
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(n1.floatValue() + n2.floatValue());
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return n1.longValue() + n2.longValue();
        }
        return n1.intValue() + n2.intValue();
    }

    public static boolean greaterThan(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return NumberUtil.map(n1).compareTo(NumberUtil.map(n2)) > 0;
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            return n1.doubleValue() > n2.doubleValue();
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return n1.floatValue() > n2.floatValue();
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return n1.longValue() > n2.longValue();
        }
        return n1.intValue() > n2.intValue();
    }

    public static Number divide(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return NumberUtil.map(n1).divide(NumberUtil.map(n2));
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            return n1.doubleValue() / n2.doubleValue();
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(n1.floatValue() / n2.floatValue());
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return n1.longValue() / n2.longValue();
        }
        return n1.intValue() / n2.intValue();
    }

    public static boolean lessThan(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return NumberUtil.map(n1).compareTo(NumberUtil.map(n2)) < 0;
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            return n1.doubleValue() < n2.doubleValue();
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return n1.floatValue() < n2.floatValue();
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return n1.longValue() < n2.longValue();
        }
        return n1.intValue() < n2.intValue();
    }

    public static Number subtract(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return NumberUtil.map(n1).subtract(NumberUtil.map(n2));
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            return n1.doubleValue() - n2.doubleValue();
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return Float.valueOf(n1.floatValue() - n2.floatValue());
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return n1.longValue() - n2.longValue();
        }
        return n1.intValue() - n2.intValue();
    }

    public static Number negative(Number n) {
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).negate();
        }
        if (n instanceof Double) {
            return -n.doubleValue();
        }
        if (n instanceof Float) {
            return Float.valueOf(-n.floatValue());
        }
        if (n instanceof Long) {
            return -n.longValue();
        }
        return -n.intValue();
    }

    public static boolean isEqual(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return NumberUtil.map(n1).equals(NumberUtil.map(n2));
        }
        if (n1 instanceof Double || n2 instanceof Double) {
            return n1.doubleValue() == n2.doubleValue();
        }
        if (n1 instanceof Float || n2 instanceof Float) {
            return n1.floatValue() == n2.floatValue();
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return n1.longValue() == n2.longValue();
        }
        return n1.intValue() == n2.intValue();
    }
}

