/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolTuple;
import org.eclipse.epsilon.eol.types.EolType;

public class EolTupleType
extends EolType {
    @Override
    public String getName() {
        return "Tuple";
    }

    @Override
    public boolean isType(Object o) {
        return o != null && o.getClass() == EolTuple.class;
    }

    @Override
    public boolean isKind(Object o) {
        return o instanceof EolTuple;
    }

    @Override
    public EolTuple createInstance() throws EolRuntimeException {
        return this.createInstance((List)null);
    }

    @Override
    public EolTuple createInstance(List<Object> parameters) throws EolRuntimeException {
        EolTuple tuple = new EolTuple();
        if (parameters != null) {
            for (Object param : parameters) {
                String key = null;
                Object value = null;
                if (param instanceof Variable) {
                    Variable variable = (Variable)param;
                    key = variable.getName();
                    value = variable.getValue();
                } else if (param instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)param;
                    key = "" + entry.getKey();
                    value = entry.getValue();
                }
                if (key == null) continue;
                tuple.put(key, value);
            }
        }
        return tuple;
    }
}

