/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.m3.MetaClass;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolType;

public class EolModelElementType
extends EolType {
    protected String modelName = "";
    protected String typeName = "";
    protected IEolModule module;
    protected ModelRepository modelRepo;
    protected MetaClass metaClass;
    protected IModel cachedModelRef;

    public EolModelElementType(MetaClass metaClass) {
        this.metaClass = metaClass;
        this.typeName = metaClass.getName();
    }

    public EolModelElementType(String modelAndMetaClass) {
        if (modelAndMetaClass.contains("!")) {
            String[] parts = modelAndMetaClass.split("!");
            this.modelName = parts[0];
            this.typeName = parts[1];
        } else {
            this.modelName = "";
            this.typeName = modelAndMetaClass;
        }
    }

    public EolModelElementType(String modelAndMetaClass, IEolContext context) throws EolModelNotFoundException, EolModelElementTypeNotFoundException {
        this(modelAndMetaClass);
        this.module = (IEolModule)context.getModule();
        this.checkAmbiguityOfType(context);
        this.getModel(true);
        this.checkAmbiguityOfTypeWithinModel(context);
    }

    private void checkAmbiguityOfType(IEolContext context) {
        if (this.modelName.isEmpty()) {
            ModelRepository.TypeAmbiguityCheckResult result = context.getModelRepository().checkAmbiguity(this.typeName);
            if (result.isAmbiguous) {
                this.issueAmbiguousTypeWarning(context, result);
            }
        }
    }

    private void issueAmbiguousTypeWarning(IEolContext context, ModelRepository.TypeAmbiguityCheckResult result) {
        String potentialTypes = CollectionUtil.join(result.namesOfOwningModels, (String)" ", element -> "'" + element + "!" + this.typeName + "'");
        context.getWarningStream().println(String.format("Warning: The type '%s' is ambiguous and could refer to any of the following: %s. The type '%s!%s' has been assumed. %s", this.typeName, potentialTypes, result.nameOfSelectedModel, this.typeName, EolModelElementType.determineLocation(context.getFrameStack().getCurrentStatement())));
    }

    private void checkAmbiguityOfTypeWithinModel(IEolContext context) {
        IModel.AmbiguityCheckResult result;
        if (this.cachedModelRef != null && (result = this.cachedModelRef.checkAmbiguity(this.typeName)).isTypeAmbiguous()) {
            this.issueAmbiguousTypeWithinModelWarning(context, result);
        }
    }

    private void issueAmbiguousTypeWithinModelWarning(IEolContext context, IModel.AmbiguityCheckResult result) {
        List formattedOptions = result.options.stream().map(option -> String.format("'%s!%s'", this.cachedModelRef.getName(), option)).collect(Collectors.toList());
        context.getWarningStream().println(String.format("Warning: The type '%s' is ambiguous and could refer to any of the following: %s. The type '%s!%s' has been assumed. %s", this.typeName, String.join((CharSequence)" ", formattedOptions), this.cachedModelRef.getName(), result.options.get(0), EolModelElementType.determineLocation(context.getFrameStack().getCurrentStatement())));
    }

    private static String determineLocation(ModuleElement statement) {
        if (statement == null) {
            return "";
        }
        return "(" + statement.getFile() + "@" + statement.getRegion().getStart().getLine() + ":" + statement.getRegion().getStart().getColumn() + ")";
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String model) {
        this.modelName = model;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String type) {
        this.typeName = type;
    }

    public Collection<?> getAllOfKind() {
        try {
            return this.getModel().getAllOfKind(this.typeName);
        }
        catch (EolModelElementTypeNotFoundException ex) {
            ex.printStackTrace();
            return Collections.emptyList();
        }
    }

    public Collection<?> getAllOfType() {
        try {
            return this.getModel().getAllOfType(this.typeName);
        }
        catch (EolModelElementTypeNotFoundException ex) {
            ex.printStackTrace();
            return Collections.emptyList();
        }
    }

    public Collection<?> getAll() {
        return this.getAllOfKind();
    }

    public Collection<?> all() {
        return this.getAllOfKind();
    }

    public Collection<?> getAllInstances() {
        return this.getAllOfKind();
    }

    public Collection<?> allInstances() {
        return this.getAllOfKind();
    }

    public boolean isInstantiable() throws EolModelElementTypeNotFoundException {
        return this.getModel().isInstantiable(this.typeName);
    }

    @Override
    public boolean isType(Object o) {
        try {
            return this.getModel().isOfType(o, this.typeName);
        }
        catch (EolModelElementTypeNotFoundException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public Object createInstance() throws EolRuntimeException {
        return this.getModel().createInstance(this.typeName);
    }

    @Override
    public Object createInstance(List<Object> parameters) throws EolRuntimeException {
        return this.getModel().createInstance(this.typeName, parameters);
    }

    @Override
    public boolean isKind(Object o) {
        try {
            return this.getModel().isOfKind(o, this.typeName);
        }
        catch (EolModelElementTypeNotFoundException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public String getName() {
        String name = "";
        if (!this.modelName.isEmpty()) {
            name = String.valueOf(this.modelName) + "!";
        }
        return String.valueOf(name) + this.typeName;
    }

    public IModel getModel() throws EolModelElementTypeNotFoundException {
        return this.getModel(this.module.getContext().getModelRepository() != this.modelRepo);
    }

    public IModel getModel(boolean updateCached) throws EolModelElementTypeNotFoundException {
        if (this.cachedModelRef == null || updateCached) {
            block4: {
                this.modelRepo = this.module.getContext().getModelRepository();
                try {
                    this.cachedModelRef = this.modelRepo.getModelByName(this.modelName);
                }
                catch (EolModelNotFoundException ex) {
                    Variable modelVariable = this.module.getContext().getFrameStack().get(this.modelName);
                    if (modelVariable == null || !(modelVariable.getValue() instanceof IModel)) break block4;
                    this.cachedModelRef = (IModel)modelVariable.getValue();
                }
            }
            if (this.cachedModelRef == null || !this.cachedModelRef.hasType(this.typeName)) {
                throw new EolModelElementTypeNotFoundException(this.modelName, this.typeName);
            }
        }
        return this.cachedModelRef;
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.module, this.metaClass != null ? this.metaClass.getName() : this.metaClass);
    }

    @Override
    public boolean equals(Object other) {
        boolean eq = super.equals(other);
        if (!eq) {
            return false;
        }
        EolModelElementType eme = (EolModelElementType)other;
        eq = Objects.equals(this.getName(), eme.getName());
        if (eq && (this.metaClass != null || eme.metaClass != null)) {
            if (this.metaClass == null || eme.metaClass == null) {
                return false;
            }
            eq = Objects.equals(this.metaClass.getName(), eme.metaClass.getName());
        }
        eq = eq && Objects.equals(this.module, eme.module);
        return eq;
    }

    @Override
    public List<EolType> getParentTypes() {
        if (this.metaClass != null && !this.metaClass.getSuperTypes().isEmpty()) {
            return this.metaClass.getSuperTypes().stream().map(s -> new EolModelElementType((MetaClass)s)).collect(Collectors.toList());
        }
        return super.getParentTypes();
    }
}

