/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.eol.types.concurrent.EolConcurrentMap;

public class EolMapType
extends EolType {
    public static final EolMapType Map = new EolMapType("Map");
    public static final EolMapType ConcurrentMap = new EolMapType("ConcurrentMap");
    protected EolType keyType;
    protected EolType valueType;
    private final String name;

    public EolMapType(String name) {
        this(EolAnyType.Instance, EolAnyType.Instance, "ConcurrentMap".equals(name));
    }

    public EolMapType() {
        this("Map");
    }

    public EolMapType(EolType keyType, EolType valueType) {
        this(keyType, valueType, false);
    }

    public EolMapType(EolType keyType, EolType valueType, boolean concurrent) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.name = concurrent ? "ConcurrentMap" : "Map";
    }

    public boolean isConcurrent() {
        return this.name.contains("Concurrent");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isType(Object o) {
        return o != null && o.getClass() == (this.isConcurrent() ? EolConcurrentMap.class : EolMap.class);
    }

    @Override
    public boolean isKind(Object o) {
        return o instanceof EolMap;
    }

    @Override
    public EolMap<Object, Object> createInstance() throws EolRuntimeException {
        return this.isConcurrent() ? new EolConcurrentMap() : new EolMap();
    }

    @Override
    public EolMap<Object, Object> createInstance(List<Object> parameters) throws EolRuntimeException {
        return this.createInstance();
    }

    public void setKeyType(EolType keyType) {
        this.keyType = keyType;
    }

    public EolType getKeyType() {
        return this.keyType;
    }

    public void setValueType(EolType valueType) {
        this.valueType = valueType;
    }

    public EolType getValueType() {
        return this.valueType;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + "<" + this.keyType + ", " + this.valueType + ">";
    }
}

