/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationParametersException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolSet;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.eol.types.IEolCollectionTypeResolver;
import org.eclipse.epsilon.eol.types.concurrent.EolConcurrentBag;
import org.eclipse.epsilon.eol.types.concurrent.EolConcurrentSet;

public class EolCollectionType
extends EolType {
    protected static Set<IEolCollectionTypeResolver> collectionTypeResolvers;
    protected EolType contentType = EolAnyType.Instance;
    private String name;
    public static final EolCollectionType Collection;
    public static final EolCollectionType Bag;
    public static final EolCollectionType Sequence;
    public static final EolCollectionType Set;
    public static final EolCollectionType OrderedSet;
    public static final EolCollectionType ConcurrentBag;
    public static final EolCollectionType ConcurrentSet;

    static {
        Collection = new EolCollectionType("Collection");
        Bag = new EolCollectionType("Bag");
        Sequence = new EolCollectionType("Sequence");
        Set = new EolCollectionType("Set");
        OrderedSet = new EolCollectionType("OrderedSet");
        ConcurrentBag = new EolCollectionType("ConcurrentBag");
        ConcurrentSet = new EolCollectionType("ConcurrentSet");
    }

    public static Set<IEolCollectionTypeResolver> getCollectionTypeResolvers() {
        if (collectionTypeResolvers == null) {
            collectionTypeResolvers = new HashSet<IEolCollectionTypeResolver>();
        }
        return collectionTypeResolvers;
    }

    public EolCollectionType(String name) {
        this.name = name;
    }

    public EolCollectionType(String name, EolType contentType) {
        this(name);
        this.contentType = contentType;
    }

    public EolCollectionType getTypeOf(Collection<?> c) {
        if (c instanceof EolConcurrentSet) {
            return ConcurrentSet;
        }
        if (c instanceof EolConcurrentBag) {
            return ConcurrentBag;
        }
        if (c instanceof EolSequence) {
            return Sequence;
        }
        if (c instanceof EolOrderedSet) {
            return OrderedSet;
        }
        if (c instanceof EolSet) {
            return Set;
        }
        for (IEolCollectionTypeResolver collectionTypeResolver : EolCollectionType.getCollectionTypeResolvers()) {
            if (!collectionTypeResolver.canResolveType(c)) continue;
            return collectionTypeResolver.resolveType(c);
        }
        if (c instanceof List) {
            return c instanceof Set ? OrderedSet : Sequence;
        }
        if (c instanceof Set) {
            return Set;
        }
        return Bag;
    }

    @Override
    public boolean isType(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        if (this.isCollection()) {
            return false;
        }
        return Objects.equals(this.getTypeOf(c).getName(), this.getName());
    }

    @Override
    public Collection<Object> createInstance() throws EolRuntimeException {
        if (this.isCollection()) {
            return null;
        }
        if (this.isConcurrentBag()) {
            return new EolConcurrentBag<Object>();
        }
        if (this.isConcurrentSet()) {
            return new EolConcurrentSet<Object>();
        }
        if (this.isSet()) {
            return new EolSet<Object>();
        }
        if (this.isSequence()) {
            return new EolSequence<Object>();
        }
        if (this.isOrderedSet()) {
            return new EolOrderedSet<Object>();
        }
        if (this.isBag()) {
            return new EolBag<Object>();
        }
        throw new EolRuntimeException("Unknown collection type");
    }

    @Override
    public Object createInstance(List<Object> parameters) throws EolRuntimeException {
        throw new EolIllegalOperationParametersException("createInstance");
    }

    @Override
    public boolean isKind(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        EolCollectionType collectionType = this.getTypeOf((Collection)o);
        if (this.isCollection()) {
            return true;
        }
        if (this.isConcurrentBag()) {
            return collectionType.isConcurrentBag();
        }
        if (this.isConcurrentSet()) {
            return collectionType.isConcurrentSet();
        }
        if (this.isSequence()) {
            return collectionType.isSequence();
        }
        if (this.isOrderedSet()) {
            return collectionType.isOrderedSet();
        }
        if (this.isBag()) {
            return collectionType.isBag() || collectionType.isSequence() || collectionType.isConcurrentBag();
        }
        if (this.isSet()) {
            return collectionType.isSet() || collectionType.isOrderedSet() || collectionType.isConcurrentSet();
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static String getTypeName(Collection<?> c) {
        if (Bag.isType(c)) {
            return Bag.getName();
        }
        if (Sequence.isType(c)) {
            return Sequence.getName();
        }
        if (OrderedSet.isType(c)) {
            return OrderedSet.getName();
        }
        if (Set.isType(c)) {
            return Set.getName();
        }
        if (ConcurrentBag.isType(c)) {
            return ConcurrentBag.getName();
        }
        if (ConcurrentSet.isType(c)) {
            return ConcurrentSet.getName();
        }
        return c.getClass().getSimpleName();
    }

    public static <T> Collection<T> createSameType(Collection<T> c) {
        if (Bag.isType(c)) {
            return new EolBag();
        }
        if (Sequence.isType(c)) {
            return new EolSequence();
        }
        if (OrderedSet.isType(c)) {
            return new EolOrderedSet();
        }
        if (Set.isType(c)) {
            return new EolSet();
        }
        if (ConcurrentBag.isType(c)) {
            return new EolConcurrentBag();
        }
        if (ConcurrentSet.isType(c)) {
            return new EolConcurrentSet();
        }
        return null;
    }

    public static <T> Collection<T> clone(Collection<T> c) {
        Collection<T> clone = EolCollectionType.createSameType(c);
        clone.addAll(c);
        return clone;
    }

    public static <T> Collection<T> join(Collection<T> c1, Collection<T> c2) {
        Collection<T> joined = EolCollectionType.createSameType(c1);
        joined.addAll(c1);
        joined.addAll(c2);
        return joined;
    }

    public static boolean isUnique(Collection<?> c) {
        return Set.isType(c) || OrderedSet.isType(c) || ConcurrentSet.isType(c);
    }

    public static boolean isOrdered(Collection<?> c) {
        return Sequence.isType(c) || OrderedSet.isType(c);
    }

    public boolean isBag() {
        return "Bag".equals(this.getName());
    }

    public boolean isSequence() {
        return "Sequence".equals(this.getName());
    }

    public boolean isSet() {
        return "Set".equals(this.getName());
    }

    public boolean isOrderedSet() {
        return "OrderedSet".equals(this.getName());
    }

    public boolean isCollection() {
        return "Collection".equals(this.getName());
    }

    public boolean isConcurrentBag() {
        return "ConcurrentBag".equals(this.getName());
    }

    public boolean isConcurrentSet() {
        return "ConcurrentSet".equals(this.getName());
    }

    public EolType getContentType() {
        return this.contentType;
    }

    public void setContentType(EolType contentType) {
        this.contentType = contentType;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + "<" + this.getContentType() + ">";
    }

    @Override
    public EolType getParentType() {
        if (this.isBag() || this.isSet() || this.isOrderedSet() || this.isSequence()) {
            return new EolCollectionType("Collection", this.getContentType());
        }
        if (!(this.getContentType() instanceof EolAnyType)) {
            return new EolCollectionType("Collection", EolAnyType.Instance);
        }
        return EolAnyType.Instance;
    }
}

