/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.AbstractToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public class EolClasspathNativeTypeDelegate
extends AbstractToolNativeTypeDelegate {
    private final ClassLoader fClassLoader;

    public EolClasspathNativeTypeDelegate() {
        this(EolClasspathNativeTypeDelegate.class.getClassLoader());
    }

    public EolClasspathNativeTypeDelegate(ClassLoader classLoader) {
        this.fClassLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    @Override
    public boolean knowsAbout(String clazz) {
        try {
            this.fClassLoader.loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public Object createInstance(String clazz, List<Object> parameters) throws EolRuntimeException {
        block7: {
            try {
                Class<?> c = this.fClassLoader.loadClass(clazz);
                int paramsSize = parameters.size();
                if (paramsSize > 0) {
                    Constructor<?>[] constructorArray = c.getConstructors();
                    int n = constructorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constructor<?> con = constructorArray[n2];
                        Class<?>[] paramTypes = con.getParameterTypes();
                        if (paramTypes.length == paramsSize) {
                            boolean parameterTypesMatch = true;
                            int i = 0;
                            while (i < paramsSize && parameterTypesMatch) {
                                parameterTypesMatch = ReflectionUtil.isInstance(paramTypes[i], parameters.get(i));
                                ++i;
                            }
                            if (parameterTypesMatch) {
                                return con.newInstance(parameters.toArray(new Object[paramsSize]));
                            }
                        }
                        ++n2;
                    }
                    break block7;
                }
                return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new EolInternalException(e);
            }
        }
        throw new EolRuntimeException("Native type " + clazz + " does not define a suitable constructor for arguments " + parameters);
    }

    public Class<?>[] getTypes(Collection<Object> objects) {
        Class[] types = new Class[objects.size()];
        int i = 0;
        for (Object o : objects) {
            types[i++] = o.getClass();
        }
        return types;
    }
}

