/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Queue;
import org.eclipse.epsilon.common.util.OperatingSystem;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.AsyncStatementInstance;
import org.eclipse.epsilon.eol.tools.AbstractTool;
import org.eclipse.epsilon.eol.userinput.IUserInput;

public class EolSystem
extends AbstractTool {
    public IUserInput getUser() {
        return this.context.getUserInput();
    }

    public PrintStream getOut() {
        return this.context.getOutputStream();
    }

    public PrintStream getErr() {
        return this.context.getErrorStream();
    }

    public String getPlatformProperty(String property) {
        return System.getProperty(property);
    }

    public void execAsync() throws EolRuntimeException {
        Queue<AsyncStatementInstance> queue = this.context.getAsyncStatementsQueue();
        while (!queue.isEmpty()) {
            queue.poll().execute(this.context);
        }
    }

    public static final String executeNative(String command) throws IOException {
        return EolSystem.executeNative(command.split(" "));
    }

    public static final String executeNative(String ... commands) throws IOException {
        return OperatingSystem.executeCommand((String[])commands);
    }

    public static final Process executeNativeAsync(String command) throws IOException {
        return EolSystem.executeNativeAsync(command.split(" "));
    }

    public static final Process executeNativeAsync(String ... commands) throws IOException {
        return new ProcessBuilder(commands).start();
    }
}

