/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models.java;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotAnEnumerationValueException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertySetter;
import org.eclipse.epsilon.eol.models.IReflectiveModel;
import org.eclipse.epsilon.eol.models.Model;

public class JavaModel
extends Model
implements IReflectiveModel {
    protected Collection<Object> objects;
    protected Collection<Class<?>> classes;

    public JavaModel(String name, Collection<? extends Object> objects, Collection<? extends Class<?>> classes) {
        this(objects, classes);
        this.name = name;
    }

    public JavaModel(Collection<? extends Object> objects, Collection<? extends Class<?>> classes) {
        this.objects = new ArrayList<Object>(objects);
        this.classes = new ArrayList(classes);
    }

    JavaModel(Collection<Object> objects) {
        this(objects, JavaModel.classesFor(objects));
    }

    private static Collection<Class<?>> classesFor(Collection<Object> objects) {
        ArrayList classes = new ArrayList(objects.size());
        for (Object object : objects) {
            classes.add(object.getClass());
        }
        return classes;
    }

    public Collection<Object> allContents() {
        return this.objects;
    }

    public Class<?> classForName(String name) {
        for (Class<?> c : this.classes) {
            if (!c.getSimpleName().equals(name) && !c.getCanonicalName().replaceAll("::", ".").equals(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Object createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        Class<?> c = this.classForName(type);
        if (c != null) {
            if (this.isInstantiable(c)) {
                try {
                    Object newInstance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.objects.add(newInstance);
                    return newInstance;
                }
                catch (Exception e) {
                    throw new EolNotInstantiableModelElementTypeException(this.getName(), type);
                }
            }
            throw new EolNotInstantiableModelElementTypeException(this.getName(), type);
        }
        throw new EolModelElementTypeNotFoundException(this.getName(), type);
    }

    public boolean isInstantiable(Class<?> c) {
        return !c.isInterface();
    }

    @Override
    public void deleteElement(Object instance) throws EolRuntimeException {
        this.objects.remove(instance);
    }

    @Override
    public Collection<?> getAllOfKind(String type) throws EolModelElementTypeNotFoundException {
        Class<?> c = this.classForName(type);
        ArrayList<Object> allOfKind = new ArrayList<Object>();
        if (c != null) {
            for (Object o : this.objects) {
                if (!c.isInstance(o)) continue;
                allOfKind.add(o);
            }
            return allOfKind;
        }
        throw new EolModelElementTypeNotFoundException(this.getName(), type);
    }

    @Override
    public Collection<?> getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        Class<?> c = this.classForName(type);
        ArrayList<Object> allOfType = new ArrayList<Object>();
        if (c != null) {
            for (Object o : this.objects) {
                if (o.getClass() != c) continue;
                allOfType.add(o);
            }
            return allOfType;
        }
        throw new EolModelElementTypeNotFoundException(this.getName(), type);
    }

    @Override
    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        Class<?> c = this.classForName(metaClass);
        return c.isAssignableFrom(instance.getClass());
    }

    @Override
    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        Class<?> c = this.classForName(metaClass);
        return instance.getClass() == c;
    }

    @Override
    public Object getElementById(String id) {
        int hashCode = 0;
        try {
            hashCode = Integer.parseInt(id);
            for (Object o : this.objects) {
                if (o.hashCode() != hashCode) continue;
                return o;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public String getElementId(Object instance) {
        return String.valueOf(instance.hashCode());
    }

    @Override
    public void setElementId(Object instance, String newId) {
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getTypeOf(Object instance) {
        return instance.getClass();
    }

    @Override
    public String getTypeNameOf(Object instance) {
        return instance.getClass().getCanonicalName();
    }

    @Override
    public boolean hasType(String type) {
        return this.classForName(type) != null;
    }

    @Override
    public boolean hasPackage(String packageName) {
        return false;
    }

    @Override
    public Object getContainerOf(Object object) {
        return null;
    }

    @Override
    public boolean isInstantiable(String type) {
        return this.isInstantiable(this.classForName(type));
    }

    @Override
    public Collection<String> getPropertiesOf(String type) throws EolModelElementTypeNotFoundException {
        Class<?> clazz = this.classForName(type);
        if (clazz == null) {
            throw new EolModelElementTypeNotFoundException(this.name, type);
        }
        LinkedList<String> properties = new LinkedList<String>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("set")) {
                properties.add(StringUtil.firstToLower((String)method.getName().substring(3)));
            } else if (method.getName().startsWith("is")) {
                properties.add(StringUtil.firstToLower((String)method.getName().substring(2)));
            } else if (method.getName().startsWith("get") && method.getReturnType().isAssignableFrom(Collection.class)) {
                properties.add(StringUtil.firstToLower((String)method.getName().substring(3)));
            }
            ++n2;
        }
        return properties;
    }

    @Override
    public boolean hasProperty(String type, String property) throws EolModelElementTypeNotFoundException {
        return this.getPropertiesOf(type).contains(property);
    }

    @Override
    public IReflectivePropertySetter getPropertySetter() {
        return new JavaPropertySetter();
    }

    @Override
    public boolean isModelElement(Object instance) {
        return true;
    }

    @Override
    public boolean isEnumerationValue(Object object) {
        return false;
    }

    @Override
    public String getEnumerationTypeOf(Object literal) throws EolNotAnEnumerationValueException {
        throw new EolNotAnEnumerationValueException(literal);
    }

    @Override
    public String getEnumerationLabelOf(Object literal) throws EolNotAnEnumerationValueException {
        throw new EolNotAnEnumerationValueException(literal);
    }

    @Override
    public boolean preventLoadingOfExternalModelElements() {
        return false;
    }

    @Override
    public void load() throws EolModelLoadingException {
    }

    @Override
    public boolean owns(Object instance) {
        return this.objects.contains(instance);
    }

    @Override
    public boolean store(String location) {
        return false;
    }

    @Override
    public boolean store() {
        return false;
    }

    @Override
    public void dispose() {
        this.objects.clear();
        this.classes.clear();
        this.objects = null;
        this.classes = null;
    }

    public boolean isLoaded() {
        return this.objects != null;
    }
}

