/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.epsilon.eol.models.Model;
import org.eclipse.epsilon.eol.models.ModelRepository;

public class ModelGroup
extends Model {
    protected ArrayList<IModel> models = new ArrayList();

    public ModelGroup() {
    }

    public ModelGroup(ModelRepository repository, String metaModel) throws EolModelNotFoundException {
        this.name = metaModel;
        this.propertyGetter = new DelegatingModelElementPropertyGetter();
        for (IModel model : repository.getModels()) {
            if (!model.getAliases().contains(metaModel)) continue;
            this.models.add(model);
        }
        if (this.models.isEmpty()) {
            throw new EolModelNotFoundException(metaModel);
        }
    }

    public ArrayList<IModel> getModels() {
        return this.models;
    }

    @Override
    public void load() throws EolModelLoadingException {
        for (IModel model : this.models) {
            model.load();
        }
    }

    public String getMetaModel() {
        return null;
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        for (IModel model : this.models) {
            try {
                return model.getEnumerationValue(enumeration, label);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new EolEnumerationValueNotFoundException(enumeration, label, this.getName());
    }

    @Override
    public Collection<?> getAllOfType(String metaClass) throws EolModelElementTypeNotFoundException {
        List filtered = this.models.stream().filter(m -> m.hasType(metaClass)).collect(Collectors.toList());
        if (filtered.size() == 1) {
            return ((IModel)filtered.get(0)).getAllOfType(metaClass);
        }
        ArrayList allOfType = new ArrayList();
        for (IModel model : filtered) {
            allOfType.addAll(model.getAllOfType(metaClass));
        }
        return allOfType;
    }

    @Override
    public Collection<?> getAllOfKind(String metaClass) throws EolModelElementTypeNotFoundException {
        List filtered = this.models.stream().filter(m -> m.hasType(metaClass)).collect(Collectors.toList());
        if (filtered.size() == 1) {
            return ((IModel)filtered.get(0)).getAllOfKind(metaClass);
        }
        ArrayList allOfKind = new ArrayList();
        for (IModel model : filtered) {
            allOfKind.addAll(model.getAllOfKind(metaClass));
        }
        return allOfKind;
    }

    @Override
    public Collection<?> allContents() {
        if (this.models.size() == 1) {
            return this.models.get(0).allContents();
        }
        ArrayList allContents = new ArrayList();
        for (IModel model : this.models) {
            allContents.addAll(model.allContents());
        }
        return allContents;
    }

    @Override
    public Object getTypeOf(Object instance) {
        for (IModel model : this.models) {
            if (!model.owns(instance)) continue;
            return model.getTypeOf(instance);
        }
        return null;
    }

    @Override
    public String getTypeNameOf(Object instance) {
        for (IModel model : this.models) {
            if (!model.isModelElement(instance)) continue;
            return model.getTypeNameOf(instance);
        }
        throw new IllegalArgumentException("No grouped model can contain: " + instance + " (" + instance.getClass().getCanonicalName() + ")");
    }

    @Override
    public Object createInstance(String metaClass, Collection<Object> parameters) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (this.models.size() == 1) {
            return this.models.get(0).createInstance(metaClass, parameters);
        }
        throw new EolNotInstantiableModelElementTypeException(this.name, metaClass){

            @Override
            public String getReason() {
                return "Cannot create an instance of " + this.typeName + " because model group " + ModelGroup.this.name + " has more than one models";
            }
        };
    }

    @Override
    public Object createInstance(String metaClass) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (this.models.size() == 1) {
            return this.models.get(0).createInstance(metaClass);
        }
        throw new EolNotInstantiableModelElementTypeException(this.name, metaClass){

            @Override
            public String getReason() {
                return "Cannot create an instance of " + this.typeName + " because model group " + ModelGroup.this.name + " has more than one models";
            }
        };
    }

    @Override
    public Object getElementById(String id) {
        for (IModel model : this.models) {
            Object instance = model.getElementById(id);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    @Override
    public String getElementId(Object instance) {
        for (IModel model : this.models) {
            if (!model.owns(instance)) continue;
            return model.getElementId(instance);
        }
        return null;
    }

    @Override
    public void setElementId(Object instance, String newId) {
        for (IModel model : this.models) {
            if (!model.owns(instance)) continue;
            model.setElementId(instance, newId);
        }
    }

    @Override
    public void deleteElement(Object instance) throws EolRuntimeException {
        for (IModel model : this.models) {
            if (!model.owns(instance)) continue;
            model.deleteElement(instance);
        }
    }

    @Override
    public boolean owns(Object instance) {
        for (IModel model : this.models) {
            if (!model.owns(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean knowsAboutProperty(Object instance, String property) {
        for (IModel model : this.models) {
            if (!model.knowsAboutProperty(instance, property)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean store(String fileName) {
        return false;
    }

    @Override
    public boolean store() {
        for (IModel model : this.models) {
            model.store();
        }
        return true;
    }

    @Override
    public void dispose() {
        for (IModel model : this.models) {
            model.dispose();
        }
    }

    @Override
    public boolean isInstantiable(String metaClass) {
        for (IModel model : this.models) {
            if (!model.hasType(metaClass) || !model.isInstantiable(metaClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasType(String metaClass) {
        for (IModel model : this.models) {
            if (!model.hasType(metaClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        for (IModel model : this.models) {
            if (!model.isOfKind(instance, metaClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        for (IModel model : this.models) {
            if (!model.isOfType(instance, metaClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        this.load();
    }

    @Override
    public boolean isModelElement(Object instance) {
        for (IModel model : this.models) {
            if (!model.isModelElement(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return new DelegatingModelElementPropertySetter();
    }

    public class DelegatingModelElementPropertyGetter
    extends AbstractPropertyGetter {
        @Override
        public Object invoke(Object object, String property, IEolContext context) throws EolRuntimeException {
            for (IModel model : ModelGroup.this.models) {
                if (!model.knowsAboutProperty(object, property)) continue;
                return model.getPropertyGetter().invoke(object, property, context);
            }
            throw new EolIllegalPropertyException(object, property, context);
        }
    }

    public class DelegatingModelElementPropertySetter
    extends AbstractPropertySetter {
        @Override
        public void invoke(Object target, String property, Object value, IEolContext context) throws EolRuntimeException {
            for (IModel model : ModelGroup.this.models) {
                if (!model.knowsAboutProperty(target, property)) continue;
                IPropertySetter delegate = null;
                delegate = model.getPropertySetter();
                delegate.invoke(target, property, value, context);
                return;
            }
            throw new EolIllegalPropertyException(target, property, context);
        }
    }
}

