/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertySetter;
import org.eclipse.epsilon.eol.m3.Metamodel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.epsilon.eol.models.transactions.IModelTransactionSupport;
import org.eclipse.epsilon.eol.models.transactions.NoModelTransactionSupport;

public abstract class Model
implements IModel {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_READONLOAD = "readOnLoad";
    public static final String PROPERTY_STOREONDISPOSAL = "storeOnDisposal";
    public static final String PROPERTY_ALIASES = "aliases";
    public static final String PROPERTY_READONLY = "readOnly";
    protected static final String ENV_PREFIX = "org.eclipse.epsilon.emc.";
    protected String name;
    protected List<String> aliases = new ArrayList<String>(1);
    protected boolean storeOnDisposal = false;
    protected boolean readOnLoad = true;
    protected IPropertyGetter propertyGetter;
    protected IPropertySetter propertySetter;
    NoModelTransactionSupport transactionSupport = new NoModelTransactionSupport();

    public Model() {
        this.propertyGetter = new JavaPropertyGetter();
        this.propertySetter = new JavaPropertySetter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        this.load(properties, (String relativePath) -> String.valueOf(basePath) + relativePath);
    }

    @Override
    public void load(StringProperties properties) throws EolModelLoadingException {
        this.load(properties, (String relativePath) -> relativePath);
    }

    @Override
    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        this.setName(properties.getProperty(PROPERTY_NAME, this.name));
        this.setReadOnLoad(properties.getBooleanProperty(PROPERTY_READONLOAD, this.readOnLoad));
        this.setStoredOnDisposal(properties.getBooleanProperty(PROPERTY_STOREONDISPOSAL, this.storeOnDisposal));
        if (properties.hasProperty(PROPERTY_ALIASES)) {
            String[] aliases = properties.getProperty(PROPERTY_ALIASES).split(",");
            CollectionUtil.addCapacityIfArrayList(this.aliases, (int)aliases.length);
            String[] stringArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                this.aliases.add(alias.trim());
                ++n2;
            }
        }
    }

    @Override
    public Object createInstance(String type, Collection<Object> parameters) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        return this.createInstance(type);
    }

    public Collection<?> allInstances() {
        return this.allContents();
    }

    @Override
    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        Collection<?> allOfKind = this.getAllOfKind(metaClass);
        return allOfKind != null && allOfKind.contains(instance);
    }

    @Override
    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        Collection<?> allOfClass = this.getAllOfType(metaClass);
        return allOfClass != null && allOfClass.contains(instance);
    }

    @Override
    public String getFullyQualifiedTypeNameOf(Object instance) {
        return this.getTypeNameOf(instance);
    }

    @Override
    public boolean isModelElement(Object instance) {
        return this.owns(instance);
    }

    @Override
    public Object getTypeOf(Object instance) {
        return null;
    }

    @Override
    public boolean isReadOnLoad() {
        return this.readOnLoad;
    }

    @Override
    public boolean isStoredOnDisposal() {
        return this.storeOnDisposal;
    }

    @Override
    public void setReadOnLoad(boolean readOnLoad) {
        this.readOnLoad = readOnLoad;
    }

    @Override
    public void setStoredOnDisposal(boolean storedOnDisposal) {
        this.storeOnDisposal = storedOnDisposal;
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return this.propertyGetter;
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return this.propertySetter;
    }

    @Override
    public void dispose() {
        if (this.isStoredOnDisposal()) {
            this.store();
        }
    }

    @Override
    public boolean knowsAboutProperty(Object instance, String property) {
        return this.owns(instance);
    }

    @Override
    public IModelTransactionSupport getTransactionSupport() {
        return this.transactionSupport;
    }

    @Override
    public Metamodel getMetamodel(StringProperties properties, IRelativePathResolver resolver) {
        return null;
    }

    @Override
    public boolean isPropertySet(Object instance, String property) throws EolRuntimeException {
        return this.getPropertyGetter().invoke(instance, property, null) != null;
    }
}

