/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;
import org.eclipse.epsilon.common.util.Multimap;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.epsilon.eol.models.Model;

public abstract class CachedModel<ModelElementType>
extends Model {
    public static final String PROPERTY_CACHED = "cached";
    public static final String PROPERTY_CONCURRENT = "concurrent";
    protected Collection<ModelElementType> allContentsCache;
    protected Multimap<Object, ModelElementType> typeCache;
    protected Multimap<Object, ModelElementType> kindCache;
    boolean concurrent;
    boolean cachingEnabled;

    protected abstract Collection<ModelElementType> allContentsFromModel();

    protected abstract Collection<ModelElementType> getAllOfTypeFromModel(String var1) throws EolModelElementTypeNotFoundException;

    protected abstract Collection<ModelElementType> getAllOfKindFromModel(String var1) throws EolModelElementTypeNotFoundException;

    protected abstract ModelElementType createInstanceInModel(String var1) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException;

    protected abstract void loadModel() throws EolModelLoadingException;

    protected abstract void disposeModel();

    protected abstract boolean deleteElementInModel(Object var1) throws EolRuntimeException;

    protected abstract Object getCacheKeyForType(String var1) throws EolModelElementTypeNotFoundException;

    protected abstract Collection<String> getAllTypeNamesOf(Object var1);

    protected CachedModel() {
        this.initCaches();
    }

    protected synchronized void initCaches() {
        this.typeCache = new Multimap(this.concurrent, false, this.typeCache);
        this.kindCache = new Multimap(this.concurrent, false, this.kindCache);
        if (this.allContentsCache != null) {
            this.allContentsCache = this.wrap(this.allContentsCache);
        }
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        if (this.cachingEnabled != cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            if (cachingEnabled) {
                this.initCaches();
            } else {
                this.allContentsCache = null;
                this.kindCache = null;
                this.typeCache = null;
            }
        }
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public void setConcurrent(boolean concurrent) {
        if (this.concurrent != concurrent) {
            this.concurrent = concurrent;
            this.initCaches();
        }
    }

    protected Collection<ModelElementType> wrap(Collection<ModelElementType> contents) {
        Collection result = contents;
        if (this.isConcurrent()) {
            result = ConcurrencyUtils.concurrentOrderedCollection(contents);
        }
        return result;
    }

    protected void addToCache(String type, ModelElementType instance) throws EolModelElementTypeNotFoundException {
        assert (this.cachingEnabled);
        if (this.allContentsCache != null) {
            this.allContentsCache.add(instance);
        }
        if (this.typeCache != null) {
            Object typeCacheKey = this.getCacheKeyForType(type);
            this.typeCache.putIfPresent(typeCacheKey, instance);
        }
        if (this.kindCache != null) {
            for (String kind : this.getAllTypeNamesOf(instance)) {
                Object kindCacheKey = this.getCacheKeyForType(kind);
                this.kindCache.putIfPresent(kindCacheKey, instance);
            }
        }
    }

    protected void removeFromCache(ModelElementType instance) throws EolModelElementTypeNotFoundException {
        assert (this.cachingEnabled);
        if (this.allContentsCache != null) {
            this.allContentsCache.remove(instance);
        }
        if (this.typeCache != null) {
            Object typeCacheKey = this.getCacheKeyForType(this.getTypeNameOf(instance));
            this.typeCache.remove(typeCacheKey, instance);
        }
        if (this.kindCache != null) {
            for (String kind : this.getAllTypeNamesOf(instance)) {
                Object kindCacheKey = this.getCacheKeyForType(kind);
                this.kindCache.remove(kindCacheKey, instance);
            }
        }
    }

    public boolean isLoaded() {
        return this.allContentsCache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ModelElementType> allContents() {
        if (this.isCachingEnabled()) {
            if (this.allContentsCache == null) {
                CachedModel cachedModel = this;
                synchronized (cachedModel) {
                    if (this.allContentsCache == null) {
                        this.allContentsCache = this.wrap(this.allContentsFromModel());
                        if (this.allContentsCache == null) {
                            return this.wrap(new ArrayList(0));
                        }
                    }
                }
            }
            return this.allContentsCache;
        }
        return this.wrap(this.allContentsFromModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ModelElementType> getAllOfKindOrType(boolean isKind, String modelElementType) throws EolModelElementTypeNotFoundException {
        Collection<ModelElementType> values = null;
        if (this.isCachingEnabled()) {
            Object key;
            Multimap<Object, ModelElementType> cache = isKind ? this.kindCache : this.typeCache;
            values = cache.getMutable(key = this.getCacheKeyForType(modelElementType));
            if (values == null) {
                CachedModel cachedModel = this;
                synchronized (cachedModel) {
                    if (!this.concurrent || (values = cache.getMutable(key)) == null) {
                        values = this.wrap(isKind ? this.getAllOfKindFromModel(modelElementType) : this.getAllOfTypeFromModel(modelElementType));
                        cache.putAll(key, values, values == null);
                    }
                }
            }
        } else if (values == null) {
            values = this.wrap(isKind ? this.getAllOfKindFromModel(modelElementType) : this.getAllOfTypeFromModel(modelElementType));
        }
        return values;
    }

    public Collection<ModelElementType> getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        return this.getAllOfKindOrType(false, type);
    }

    public Collection<ModelElementType> getAllOfKind(String kind) throws EolModelElementTypeNotFoundException {
        return this.getAllOfKindOrType(true, kind);
    }

    public ModelElementType createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        ModelElementType instance = this.createInstanceInModel(type);
        if (this.isCachingEnabled()) {
            this.addToCache(type, instance);
        }
        return instance;
    }

    @Override
    public void deleteElement(Object o) throws EolRuntimeException {
        if (this.deleteElementInModel(o) && this.isCachingEnabled()) {
            this.removeFromCache(o);
        }
    }

    @Override
    public void load() throws EolModelLoadingException {
        this.clearCache();
        this.loadModel();
    }

    @Override
    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        this.setCachingEnabled(properties.getBooleanProperty(PROPERTY_CACHED, this.cachingEnabled));
        this.setConcurrent(properties.getBooleanProperty(PROPERTY_CONCURRENT, this.concurrent));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCache();
        this.disposeModel();
    }

    public void clearCache() {
        this.allContentsCache = null;
        if (this.typeCache != null) {
            this.typeCache.clear();
        }
        if (this.kindCache != null) {
            this.kindCache.clear();
        }
    }
}

