/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;
import org.eclipse.epsilon.common.launch.ProfilableRunConfiguration;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.common.util.profiling.BenchmarkUtils;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.concurrent.EolModuleParallel;
import org.eclipse.epsilon.eol.exceptions.EolParseException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.EolContextParallel;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.control.ExecutionProfiler;
import org.eclipse.epsilon.eol.launch.ProfilableIEolModule;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.ModelRepository;

public class EolRunConfiguration
extends ProfilableRunConfiguration {
    public final Map<IModel, StringProperties> modelsAndProperties;
    public final Map<String, Object> parameters;
    protected boolean loadModels;
    private final IEolModule module;

    public static Builder<? extends EolRunConfiguration, ?> Builder() {
        return new Builder(EolRunConfiguration.class);
    }

    public EolRunConfiguration(Builder<? extends EolRunConfiguration, ?> builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.modelsAndProperties = builder.modelsAndProperties;
        this.loadModels = builder.loadModels;
        this.module = Objects.requireNonNull(builder.module, "Module cannot be null!");
        IEolContext context = this.module.getContext();
        if (builder.isParallel() && builder.parallelism > 0 && context instanceof IEolContextParallel) {
            IEolContextParallel pContext = (IEolContextParallel)context;
            pContext.setParallelism(builder.parallelism);
        }
        this.id = Optional.ofNullable(builder.id).orElseGet(() -> Objects.hash(this.id, Objects.toString(this.modelsAndProperties), Objects.toString(this.module.getSourceUri())));
    }

    public EolRunConfiguration(EolRunConfiguration other) {
        super((ProfilableRunConfiguration)other);
        this.modelsAndProperties = other.modelsAndProperties;
        this.module = other.module;
        this.parameters = other.parameters;
        this.loadModels = other.loadModels;
    }

    public IEolModule getModule() {
        return this.module;
    }

    protected void preExecute() throws Exception {
        super.preExecute();
        if (this.isFirstRepeat()) {
            this.prepareModule();
        } else if (this.targetRepeats > 1) {
            this.module.getContext().getFrameStack().dispose();
            this.prepareFrameStack();
        }
        if (this.modelsAndProperties != null && !this.modelsAndProperties.isEmpty()) {
            this.addModelsToRepo();
            if (this.loadModels && (this.isFirstRepeat() || this.targetRepeats == 1)) {
                this.loadModels();
            }
        }
    }

    protected void addModelsToRepo() throws Exception {
        ModelRepository modelRepo = this.module.getContext().getModelRepository();
        for (Map.Entry<IModel, StringProperties> modelAndProp : this.modelsAndProperties.entrySet()) {
            IModel model = modelAndProp.getKey();
            if (modelRepo.getModels().contains(model)) continue;
            modelRepo.addModel(model);
        }
    }

    protected void prepareModule() throws Exception {
        if (this.profileExecution) {
            BenchmarkUtils.profileExecutionStage((Collection)this.profiledStages, (String)"Parsing script", () -> this.module.parse(this.script));
        } else {
            this.module.parse(this.script);
        }
        List<ParseProblem> parseProblems = this.module.getParseProblems();
        if (!parseProblems.isEmpty()) {
            this.writeOut(parseProblems);
            throw new EolParseException(parseProblems);
        }
        this.prepareFrameStack();
        this.module.getContext().setProfilingEnabled(this.profileExecution);
    }

    protected void prepareFrameStack() {
        if (!this.parameters.isEmpty()) {
            this.module.getContext().getFrameStack().put(this.parameters, false);
        }
    }

    protected final void loadModels() throws EolModelLoadingException {
        if (this.profileExecution) {
            BenchmarkUtils.profileExecutionStage((Collection)this.profiledStages, (String)"Loading model(s)", this::loadModelsImpl);
        } else {
            this.loadModelsImpl();
        }
    }

    protected void loadModelsImpl() throws EolModelLoadingException {
        for (Map.Entry<IModel, StringProperties> modelAndProp : this.modelsAndProperties.entrySet()) {
            IModel model = modelAndProp.getKey();
            if (model instanceof CachedModel && ((CachedModel)model).isLoaded()) continue;
            StringProperties modelProperties = modelAndProp.getValue();
            if (modelProperties != null) {
                model.load(modelProperties);
                continue;
            }
            model.load();
        }
    }

    public void reset() throws Exception {
        super.reset();
        this.module.getContext().dispose();
    }

    public void dispose() throws Exception {
        this.reset();
        this.module.getContext().getFrameStack().dispose();
        this.module.getContext().getModelRepository().dispose();
    }

    protected Object execute() throws EolRuntimeException {
        Object execResult;
        if (this.profileExecution) {
            if (this.module instanceof ProfilableIEolModule) {
                ProfilableIEolModule profMod = (ProfilableIEolModule)this.module;
                execResult = profMod.profileExecution();
                this.profiledStages.addAll(profMod.getProfiledStages());
            } else {
                execResult = BenchmarkUtils.profileExecutionStage((Collection)this.profiledStages, (String)"execute()", this.module::execute);
            }
        } else {
            execResult = this.module.execute();
        }
        return execResult;
    }

    protected List<Object> getProfilingOutput() {
        ExecutionController executionController = this.getModule().getContext().getExecutorFactory().getExecutionController();
        ArrayList<Object> prof = new ArrayList<Object>(super.getProfilingOutput());
        if (executionController instanceof ExecutionProfiler) {
            prof.addAll(Arrays.asList(this.printMarker, executionController));
        }
        return prof;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", moduleClass=" + this.module.getClass().getName() + ", module=" + this.module + "', models='" + Objects.toString(this.modelsAndProperties) + "'";
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.module, this.modelsAndProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        EolRunConfiguration other = (EolRunConfiguration)((Object)obj);
        return Objects.equals(this.module, other.module) && CollectionUtil.equalsIgnoreOrder(this.modelsAndProperties.keySet(), other.modelsAndProperties.keySet());
    }

    public static class Builder<C extends EolRunConfiguration, B extends Builder<C, B>>
    extends ProfilableRunConfiguration.Builder<C, B> {
        public IEolModule module;
        public Map<IModel, StringProperties> modelsAndProperties = new LinkedHashMap<IModel, StringProperties>(4);
        public Map<String, Object> parameters = new LinkedHashMap<String, Object>(4);
        public boolean loadModels = true;
        public int parallelism = Integer.MIN_VALUE;
        protected boolean sequential = false;

        protected Builder() {
        }

        protected Builder(Class<C> runConfigClass) {
            super(runConfigClass);
        }

        public C build() {
            if (this.module == null) {
                this.module = this.createModule();
            }
            this.module.getContext().setProfilingEnabled(this.profileExecution);
            return (C)((Object)((EolRunConfiguration)this.buildReflective(() -> {
                class InstantiableEOC
                extends EolRunConfiguration {
                    public InstantiableEOC(Builder<C, B> builder2) {
                        super(builder2);
                    }
                }
                return new InstantiableEOC(this);
            })));
        }

        protected IEolModule createModule() {
            return this.isParallel() ? new EolModuleParallel(new EolContextParallel(this.parallelism)) : new EolModule();
        }

        public B skipModelLoading() {
            return this.loadModels(false);
        }

        public B withModelLoading(boolean load) {
            return this.loadModels(load);
        }

        public B loadModels(boolean load) {
            this.loadModels = load;
            return (B)((Object)this);
        }

        public B withModule(IEolModule module) {
            this.module = module;
            return (B)((Object)this);
        }

        public B withModel(IModel model) {
            return this.withModel(model, null);
        }

        public B withModel(IModel model, StringProperties properties) {
            this.modelsAndProperties.put(model, properties);
            return (B)((Object)this);
        }

        public B withModels(Map<IModel, StringProperties> modelsAndProps) {
            this.modelsAndProperties.putAll(modelsAndProps);
            return (B)((Object)this);
        }

        public B withModels(IModel ... models) {
            IModel[] iModelArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IModel model = iModelArray[n2];
                this.withModel(model);
                ++n2;
            }
            return (B)((Object)this);
        }

        public B withProperties(Map<?, ?> properties) {
            this.modelsAndProperties.values().forEach(prop -> prop.putAll(properties));
            return (B)((Object)this);
        }

        public B withProperty(String name, Object value) {
            this.modelsAndProperties.values().forEach(prop -> {
                Object object2 = prop.put((Object)name, value);
            });
            return (B)((Object)this);
        }

        public B withParameter(String name, Object value) {
            this.parameters.put(name, value);
            return (B)((Object)this);
        }

        public B withParameters(Map<String, Object> params) {
            this.parameters.putAll(params);
            return (B)((Object)this);
        }

        public B withParallelism(int parallelism) {
            this.parallelism = parallelism;
            this.sequential = this.parallelism < 0;
            return (B)((Object)this);
        }

        public B withParallelism() {
            return this.parallel(true);
        }

        public B sequential() {
            return this.parallel(false);
        }

        public B parallel(boolean parallel) {
            return this.withParallelism(parallel ? ConcurrencyUtils.DEFAULT_PARALLELISM : Integer.MIN_VALUE);
        }

        public B parallel() {
            return this.parallel(true);
        }

        public boolean isSequential() {
            return this.sequential;
        }

        public boolean isParallel() {
            return this.parallelism > -1;
        }
    }
}

