/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.EolContextParallel;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;
import org.eclipse.epsilon.eol.execute.operations.declarative.NMatchOperation;
import org.eclipse.epsilon.eol.function.CheckedEolPredicate;

public class ParallelNMatchOperation
extends NMatchOperation {
    public ParallelNMatchOperation(NMatchOperation.MatchMode behaviour, int n) throws IllegalArgumentException {
        super(behaviour, n);
    }

    public ParallelNMatchOperation(NMatchOperation.MatchMode behaviour) {
        super(behaviour);
    }

    @Override
    protected boolean execute(int sourceSize, int targetMatches, Collection<Object> source, NameExpression operationNameExpression, List<Parameter> iterators, Expression expression, IEolContext context_) throws EolRuntimeException {
        IEolContextParallel context = EolContextParallel.convertToParallel(context_);
        AtomicInteger currentMatches = new AtomicInteger();
        AtomicInteger evaluated = new AtomicInteger();
        ArrayList<Callable<Object>> jobs = new ArrayList<Callable<Object>>(sourceSize);
        CheckedEolPredicate<Object> predicate = this.resolvePredicate(operationNameExpression, iterators, expression, context);
        AtomicBoolean keepSearching = new AtomicBoolean(true);
        for (Object item : source) {
            jobs.add(() -> {
                int evaluatedInt;
                int currentInt;
                if (keepSearching.get() && this.shouldShortCircuit(sourceSize, targetMatches, currentInt = predicate.testThrows(item) ? currentMatches.incrementAndGet() : currentMatches.get(), evaluatedInt = evaluated.incrementAndGet())) {
                    keepSearching.set(false);
                }
                return null;
            });
        }
        context.executeAll(expression, jobs);
        return this.determineResult(currentMatches.get(), targetMatches);
    }
}

