/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative.concurrent;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.EolContextParallel;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;
import org.eclipse.epsilon.eol.execute.operations.declarative.MapByOperation;
import org.eclipse.epsilon.eol.function.CheckedEolFunction;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolSequence;

public class ParallelMapByOperation
extends MapByOperation {
    @Override
    public EolMap<Object, EolSequence<Object>> execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context_) throws EolRuntimeException {
        Collection<Object> source = this.resolveSource(target, iterators, context_);
        if (source.isEmpty()) {
            return new EolMap<Object, EolSequence<Object>>();
        }
        IEolContextParallel context = EolContextParallel.convertToParallel(context_);
        ArrayList<Callable<Map.Entry>> jobs = new ArrayList<Callable<Map.Entry>>(source.size());
        Expression expression = expressions.get(0);
        CheckedEolFunction<Object, ?> function = this.resolveFunction(operationNameExpression, iterators, expression, context);
        for (Object item : source) {
            jobs.add(() -> new AbstractMap.SimpleEntry<Object, Object>(function.applyThrows(item), item));
        }
        List intermediates = context.executeAll(expression, jobs);
        return intermediates.parallelStream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            EolSequence value = new EolSequence();
            value.add(entry.getValue());
            return value;
        }, (oldVal, newVal) -> {
            oldVal.addAll(newVal);
            return oldVal;
        }, EolMap::new));
    }
}

