/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.declarative.FirstOrderOperation;
import org.eclipse.epsilon.eol.function.CheckedEolPredicate;
import org.eclipse.epsilon.eol.types.EolCollectionType;

public class SelectOperation
extends FirstOrderOperation {
    public Collection<?> execute(boolean returnOnMatch, Object target, NameExpression operationNameExpression, List<Parameter> iterators, Expression expression, IEolContext context) throws EolRuntimeException {
        Collection<Object> source = this.resolveSource(target, iterators, context);
        CheckedEolPredicate<Object> predicate = this.resolvePredicate(operationNameExpression, iterators, expression, context);
        Collection<Object> result = EolCollectionType.createSameType(source);
        for (Object item : source) {
            if (!predicate.testThrows(item)) continue;
            result.add(item);
            if (!returnOnMatch) continue;
            return result;
        }
        return result;
    }

    @Deprecated
    public Object execute(Object target, Variable iterator, Expression expression, IEolContext context, boolean returnOnMatch) throws EolRuntimeException {
        List<Parameter> parameters = new ArrayList<Parameter>();
        if (iterator != null) {
            parameters = Arrays.asList(new Parameter(new NameExpression(iterator.getName()), new TypeExpression(iterator.getType().getName())));
        }
        return this.execute(returnOnMatch, target, null, parameters, expression, context);
    }

    @Override
    public Collection<?> execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        Expression expression = null;
        Variable variable = null;
        if (!expressions.isEmpty()) {
            expression = expressions.get(0);
        }
        if (!iterators.isEmpty()) {
            variable = new Variable(iterators.get(0).getName(), iterators.get(0).getType(context));
        }
        return (Collection)this.execute(target, variable, expression, context, false);
    }
}

