/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationParametersException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.declarative.FirstOrderOperation;
import org.eclipse.epsilon.eol.function.CheckedEolPredicate;

public class NMatchOperation
extends FirstOrderOperation {
    private final int n;
    protected final MatchMode mode;

    public NMatchOperation(MatchMode behaviour) {
        this.n = -1;
        this.mode = behaviour;
    }

    public NMatchOperation(MatchMode behaviour, int n) throws IllegalArgumentException {
        this.n = n;
        if (this.n < 0) {
            throw new IllegalArgumentException("Target matches can't be negative!");
        }
        this.mode = behaviour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Boolean execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        int targetMatches;
        if (this.n >= 0) {
            targetMatches = this.n;
        } else {
            if (expressions.size() <= 1) throw new EolIllegalOperationParametersException("nMatch");
            Object userDefinedN = expressions.get(1).execute(context);
            if (userDefinedN instanceof Integer) {
                targetMatches = (Integer)userDefinedN;
            } else {
                String actualType = userDefinedN != null ? userDefinedN.getClass().getTypeName() : "null";
                throw new EolIllegalOperationParametersException("nMatch", "Integer", actualType, expressions.get(1));
            }
        }
        Collection<Object> source = this.resolveSource(target, iterators, context);
        int sourceSize = source.size();
        if (this.mode == MatchMode.MAXIMUM || sourceSize >= targetMatches) return this.execute(sourceSize, targetMatches, source, operationNameExpression, iterators, expressions.get(0), context);
        return false;
    }

    protected boolean shouldShortCircuit(int sourceSize, int targetMatches, int currentMatches, int currentIndex) {
        return currentMatches > targetMatches || this.mode == MatchMode.MINIMUM && currentMatches == targetMatches || sourceSize - currentIndex < targetMatches - currentMatches;
    }

    protected boolean determineResult(int currentMatches, int targetMatches) {
        switch (this.mode) {
            case EXACT: {
                return currentMatches == targetMatches;
            }
            case MINIMUM: {
                return currentMatches >= targetMatches;
            }
            case MAXIMUM: {
                return currentMatches <= targetMatches;
            }
        }
        return false;
    }

    protected boolean execute(int sourceSize, int targetMatches, Collection<Object> source, NameExpression operationNameExpression, List<Parameter> iterators, Expression expression, IEolContext context) throws EolRuntimeException {
        CheckedEolPredicate<Object> predicate = this.resolvePredicate(operationNameExpression, iterators, expression, context);
        int currentIndex = 0;
        int currentMatches = 0;
        for (Object item : source) {
            ++currentIndex;
            if (predicate.testThrows(item)) {
                ++currentMatches;
            }
            if (this.shouldShortCircuit(sourceSize, targetMatches, currentMatches, currentIndex)) break;
        }
        return this.determineResult(currentMatches, targetMatches);
    }

    public static enum MatchMode {
        EXACT,
        MINIMUM,
        MAXIMUM;

    }
}

