/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.declarative.FirstOrderOperation;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolType;

public class ClosureOperation
extends FirstOrderOperation {
    protected void closure(Collection<Object> closure, Collection<?> source, Parameter parameter, Expression expression, IEolContext context) throws EolRuntimeException {
        FrameStack scope = context.getFrameStack();
        ExecutorFactory executorFactory = context.getExecutorFactory();
        EolType parameterType = parameter.getType(context);
        for (Object item : source) {
            scope.enterLocal(FrameType.UNPROTECTED, (ModuleElement)expression, ClosureOperation.createIteratorVariable(item, parameter, context));
            Object bodyResult = executorFactory.execute(expression, context);
            if (bodyResult != null) {
                Collection bodyCollection = CollectionUtil.asCollection((Object)bodyResult);
                for (Object result : bodyCollection) {
                    if (result == null || !closure.add(result) || parameterType != null && !parameterType.isKind(result)) continue;
                    this.closure(closure, Collections.singletonList(result), parameter, expression, context);
                }
            }
            scope.leaveLocal(expression);
        }
    }

    @Override
    public Object execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        Collection<Object> source = this.resolveSource(target, iterators, context);
        if (source.isEmpty()) {
            return new EolSequence();
        }
        Set accumulator = CollectionUtil.createDefaultSet();
        this.closure(accumulator, source, iterators.get(0), expressions.get(0), context);
        List results = CollectionUtil.createDefaultList();
        results.addAll(accumulator);
        return results;
    }
}

