/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.declarative;

import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.declarative.FirstOrderOperation;
import org.eclipse.epsilon.eol.types.EolMap;

public class AggregateOperation
extends FirstOrderOperation {
    @Override
    public EolMap<?, ?> execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        EolMap<Object, Object> result = new EolMap<Object, Object>();
        Collection<Object> source = this.resolveSource(target, iterators, context);
        if (source.isEmpty()) {
            return result;
        }
        Expression keyExpression = expressions.get(0);
        Expression valueExpression = expressions.get(1);
        Expression initialExpression = expressions.size() > 2 ? expressions.get(2) : null;
        FrameStack scope = context.getFrameStack();
        ExecutorFactory executorFactory = context.getExecutorFactory();
        for (Object item : source) {
            scope.enterLocal(FrameType.UNPROTECTED, (ModuleElement)keyExpression, AggregateOperation.createIteratorVariable(item, iterators.get(0), context));
            Object keyResult = executorFactory.execute(keyExpression, context);
            Object total = result.containsKey(keyResult) ? result.get(keyResult) : executorFactory.execute(initialExpression, context);
            scope.put(Variable.createReadOnlyVariable("total", total));
            Object valueResult = executorFactory.execute(valueExpression, context);
            result.put(keyResult, valueResult);
            scope.leaveLocal(keyExpression);
        }
        return result;
    }
}

