/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

public class StringOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return target instanceof String || target instanceof Character;
    }

    public Object toEnum() throws Exception {
        return this.getContext().getModelRepository().getEnumerationValue("" + this.getTarget());
    }

    @Override
    public void setTarget(Object target) {
        super.setTarget(target instanceof Character ? "" + target : target);
    }

    public String escapeXml() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Text text = document.createTextNode("" + this.getTarget());
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(text);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(source, result);
        return writer.toString();
    }

    public String firstToUpperCase() {
        String value = (String)this.getTarget();
        return String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1, value.length());
    }

    public String characterAt(int index) {
        String value = (String)this.getTarget();
        return String.valueOf(value.charAt(index));
    }

    public String firstToLowerCase() {
        String value = (String)this.getTarget();
        return String.valueOf(value.substring(0, 1).toLowerCase()) + value.substring(1, value.length());
    }

    public String ftuc() {
        return this.firstToUpperCase();
    }

    public String ftlc() {
        return this.firstToLowerCase();
    }

    public void store(String where) throws Exception {
        String value = (String)this.getTarget();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(where);){
            fos.write(value.getBytes());
            fos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean isSubstringOf(String str) {
        String value = (String)this.getTarget();
        return str == null ? false : str.indexOf(value) > -1;
    }

    public List<String> toCharSequence() {
        String value = (String)this.getTarget();
        List charSeq = CollectionUtil.createDefaultList();
        int i = 0;
        while (i < value.length()) {
            charSeq.add(String.valueOf(value.charAt(i)));
            ++i;
        }
        return charSeq;
    }

    public String pad(int width, String padding, boolean right) {
        String result = (String)this.getTarget();
        int pad = width - result.length();
        while (pad > 0) {
            result = right ? String.valueOf(result) + padding : String.valueOf(padding) + result;
            --pad;
        }
        return result;
    }
}

