/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.contributors.AnyOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.ArrayOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.BasicEUnitOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.BooleanOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.DateOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.IntegerOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.IterableOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.ModelElementOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.NumberOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.ReflectiveOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.ScalarOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.StringOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.WrapperOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.compatibility.StringCompatibilityOperationContributor;

public class OperationContributorRegistry {
    private final List<OperationContributor> operationContributorsCache = this.getDefaultOperationContributors();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OperationContributor operationContributor) {
        List<OperationContributor> list = this.operationContributorsCache;
        synchronized (list) {
            this.operationContributorsCache.add(operationContributor);
        }
    }

    protected List<OperationContributor> getDefaultOperationContributors() {
        return new ArrayList<OperationContributor>(Arrays.asList(new StringCompatibilityOperationContributor(), new ReflectiveOperationContributor(), new WrapperOperationContributor(), new StringOperationContributor(), new IntegerOperationContributor(), new NumberOperationContributor(), new BooleanOperationContributor(), new DateOperationContributor(), new ArrayOperationContributor(), new IterableOperationContributor(), new ScalarOperationContributor(), new AnyOperationContributor(), new BasicEUnitOperationContributor(), new ModelElementOperationContributor()));
    }

    public ObjectMethod findContributedMethodForUnevaluatedParameters(Object target, String name, List<Expression> parameterExpressions, IEolContext context) {
        for (OperationContributor c : this.getOperationContributorsFor(target, context)) {
            ObjectMethod objectMethod = c.findContributedMethodForUnevaluatedParameters(target, name, parameterExpressions, context);
            if (objectMethod == null) continue;
            return objectMethod;
        }
        return null;
    }

    public ObjectMethod findContributedMethodForEvaluatedParameters(Object target, String name, Object[] parameters, IEolContext context) {
        for (OperationContributor c : this.getOperationContributorsFor(target, context)) {
            ObjectMethod objectMethod = c.findContributedMethodForEvaluatedParameters(target, name, parameters, context, false);
            if (objectMethod == null) continue;
            return objectMethod;
        }
        return null;
    }

    protected Collection<OperationContributor> getOperationContributorsFor(Object target, IEolContext context) {
        return this.stream().filter(oc -> {
            oc.setContext(context);
            Throwable throwable = null;
            Object var4_5 = null;
            try (OperationContributor opContributor = oc;){
                return opContributor.contributesTo(target);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }).collect(Collectors.toList());
    }

    public Stream<OperationContributor> stream() {
        return this.operationContributorsCache.stream();
    }
}

