/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.util.stream.LongStream;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.types.NumberUtil;

public class NumberOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return target instanceof Number;
    }

    @Override
    protected Number getTarget() {
        return (Number)super.getTarget();
    }

    public long factorial() {
        long n = this.getTarget().longValue();
        if (n > 20L || n < 0L) {
            throw new IllegalArgumentException(String.valueOf(n) + " is out of range");
        }
        return LongStream.rangeClosed(2L, n).reduce(1L, (a, b) -> a * b);
    }

    public Number min(Number other) {
        Number self = this.getTarget();
        return NumberUtil.lessThan(self, other) ? (Number)self : (Number)other;
    }

    public Number max(Number other) {
        Number self = this.getTarget();
        return NumberUtil.greaterThan(self, other) ? (Number)self : (Number)other;
    }

    public int floor() {
        return (int)Math.floor(this.asDouble());
    }

    public Number pow(Number n) {
        Double pow = Math.pow(this.asDouble(), n.doubleValue());
        if (this.getTarget() instanceof Integer && n instanceof Integer && NumberUtil.greaterThan(n, 0)) {
            return pow.intValue();
        }
        return pow;
    }

    public int ceiling() {
        return (int)Math.ceil(this.asDouble());
    }

    public int round() {
        return Math.round(this.asFloat());
    }

    public double ln() {
        return this.log();
    }

    public double log() {
        return Math.log(this.asDouble());
    }

    public double log10() {
        return Math.log10(this.asDouble());
    }

    public Number abs() {
        Number target = this.getTarget();
        if (target instanceof Integer) {
            return Math.abs((Integer)target);
        }
        if (target instanceof Float) {
            return Float.valueOf(Math.abs(((Float)target).floatValue()));
        }
        if (target instanceof Double) {
            return Math.abs((Double)target);
        }
        if (target instanceof Long) {
            return Math.abs((Long)target);
        }
        return null;
    }

    public double asReal() {
        return this.asFloat();
    }

    public double asDouble() {
        return this.getTarget().doubleValue();
    }

    public float asFloat() {
        return this.getTarget().floatValue();
    }

    public int asInteger() {
        return this.getTarget().intValue();
    }

    public long asLong() {
        return this.getTarget().longValue();
    }
}

