/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IUndefined;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolMapType;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolType;

public class AnyOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return !(target instanceof EolNoType.EolNoTypeInstance);
    }

    public Object type() {
        Object target = this.getTarget();
        if (EolPrimitiveType.String.isType(target)) {
            return EolPrimitiveType.String;
        }
        if (EolPrimitiveType.Boolean.isType(target)) {
            return EolPrimitiveType.Boolean;
        }
        if (EolPrimitiveType.Real.isType(target)) {
            return EolPrimitiveType.Real;
        }
        if (EolPrimitiveType.Integer.isType(target)) {
            return EolPrimitiveType.Integer;
        }
        if (EolCollectionType.Bag.isType(target)) {
            return EolCollectionType.Bag;
        }
        if (EolCollectionType.Sequence.isType(target)) {
            return EolCollectionType.Sequence;
        }
        if (EolCollectionType.Set.isType(target)) {
            return EolCollectionType.Set;
        }
        if (EolCollectionType.OrderedSet.isType(target)) {
            return EolCollectionType.OrderedSet;
        }
        if (EolCollectionType.ConcurrentBag.isType(target)) {
            return EolCollectionType.ConcurrentBag;
        }
        if (EolCollectionType.ConcurrentSet.isType(target)) {
            return EolCollectionType.ConcurrentSet;
        }
        if (EolMapType.Map.isType(target)) {
            return EolMapType.Map;
        }
        if (EolMapType.ConcurrentMap.isType(target)) {
            return EolMapType.ConcurrentMap;
        }
        IModel model = this.getContext().getModelRepository().getOwningModel(target);
        if (model != null) {
            return model.getTypeOf(target);
        }
        return null;
    }

    public boolean instanceOf(EolType type) {
        return this.isKindOf(type);
    }

    public boolean isTypeOf(EolType type) {
        return type.isType(this.getTarget());
    }

    public boolean isKindOf(EolType type) {
        return type.isKind(this.getTarget());
    }

    public Class<?> getNativeType() {
        return this.getTarget().getClass();
    }

    public Class<?> nativeType() {
        return this.getNativeType();
    }

    public IModel getOwningModel() {
        return this.owningModel();
    }

    public IModel owningModel() {
        return this.getContext().getModelRepository().getOwningModel(this.getTarget());
    }

    public boolean hasProperty(String property) throws Exception {
        Object target = this.getTarget();
        IPropertyGetter getter = this.getContext().getIntrospectionManager().getPropertyGetterFor(target, property, this.getContext());
        return getter.hasProperty(target, property, this.getContext());
    }

    public String asString() {
        return this.getContext().getPrettyPrinterManager().print(this.getTarget());
    }

    public boolean isDefined() {
        Object target = this.getTarget();
        if (target == null || target instanceof IUndefined) {
            return false;
        }
        return !(target instanceof String) || !((String)target).isEmpty();
    }

    public final boolean isUndefined() {
        return !this.isDefined();
    }

    public Object ifUndefined(Object alternative) {
        if (this.isUndefined()) {
            return alternative;
        }
        return this.getTarget();
    }

    public Object println() {
        return this.println("", "");
    }

    public Object println(Object prefix) {
        return this.println(prefix, "");
    }

    public Object println(Object prefix, Object suffix) {
        this.getContext().getOutputStream().println(prefix + this.getContext().getPrettyPrinterManager().print(this.getTarget()) + suffix);
        return this.getTarget();
    }

    public Object print() {
        return this.print("", "");
    }

    public Object print(Object prefix) {
        return this.print(prefix, "");
    }

    public Object print(Object prefix, Object suffix) {
        this.getContext().getOutputStream().print(prefix + this.getContext().getPrettyPrinterManager().print(this.getTarget()) + suffix);
        return this.getTarget();
    }

    public Object err() {
        return this.err("", "");
    }

    public Object err(Object prefix) {
        return this.err(prefix, "");
    }

    public Object err(Object prefix, Object suffix) {
        this.getContext().getErrorStream().print(prefix + this.getContext().getPrettyPrinterManager().print(this.getTarget()) + suffix);
        return this.getTarget();
    }

    public Object errln() {
        return this.errln("", "");
    }

    public Object errln(Object prefix) {
        return this.errln(prefix, "");
    }

    public Object errln(Object prefix, Object suffix) {
        this.getContext().getErrorStream().println(prefix + this.getContext().getPrettyPrinterManager().print(this.getTarget()) + suffix);
        return this.getTarget();
    }

    public String format(String formatString) {
        return String.format(formatString, this.getTarget());
    }

    public int asInteger() {
        Object target = this.getTarget();
        try {
            return Integer.parseInt(target.toString());
        }
        catch (Exception ex) {
            if (target instanceof CharSequence && ((CharSequence)target).length() == 1) {
                return ((CharSequence)target).charAt(0);
            }
            throw ex;
        }
    }

    public boolean isInteger() {
        String value = this.getTarget().toString();
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isReal() {
        String value = this.getTarget().toString();
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public float asReal() {
        String value = this.getTarget().toString();
        return Float.parseFloat(value);
    }

    public double asDouble() {
        String value = this.getTarget().toString();
        return Double.parseDouble(value);
    }

    public float asFloat() {
        String value = this.getTarget().toString();
        return Float.parseFloat(value);
    }

    public long asLong() {
        String value = this.getTarget().toString();
        return Long.parseLong(value);
    }

    public boolean asBoolean() {
        String value = this.getTarget().toString();
        return Boolean.parseBoolean(value);
    }

    public String asUnicode() {
        String value = this.getTarget().toString();
        return "" + (char)Integer.parseInt(value, 16);
    }

    public Date asDate(String format) throws ParseException {
        return new SimpleDateFormat(format).parse(this.getTarget().toString());
    }

    public Object asVar(String name) {
        Object target = this.getTarget();
        this.getContext().getFrameStack().put(new Variable(name, this.getTarget(), EolAnyType.Instance));
        return target;
    }
}

