/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.AggregateOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.AsOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.ClosureOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.CollectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.CountOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.DelegateBasedOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.ExistsOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.FindOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.FindOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.ForAllOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.MapByOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.NMatchOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.RejectOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.RejectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectFirstOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SortByOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelCollectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelCountOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelExistsOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelForAllOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelMapByOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelNMatchOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelRejectOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelRejectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelSelectOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelSelectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.concurrent.ParallelSortByOperation;
import org.eclipse.epsilon.eol.execute.operations.simple.assertions.AssertErrorOperation;
import org.eclipse.epsilon.eol.execute.operations.simple.assertions.AssertOperation;
import org.eclipse.epsilon.eol.models.IModel;

public class EolOperationFactory {
    protected final Map<String, AbstractOperation> operationCache = new HashMap<String, AbstractOperation>(64);

    public EolOperationFactory() {
        this.operationCache.put("assert", new AssertOperation());
        this.operationCache.put("assertError", new AssertErrorOperation());
        this.operationCache.put("atLeastNMatch", new NMatchOperation(NMatchOperation.MatchMode.MINIMUM));
        this.operationCache.put("atMostNMatch", new NMatchOperation(NMatchOperation.MatchMode.MAXIMUM));
        this.operationCache.put("collect", new CollectOperation());
        this.operationCache.put("count", new CountOperation());
        this.operationCache.put("exists", new ExistsOperation());
        this.operationCache.put("none", new NMatchOperation(NMatchOperation.MatchMode.EXACT, 0));
        this.operationCache.put("one", new NMatchOperation(NMatchOperation.MatchMode.EXACT, 1));
        this.operationCache.put("nMatch", new NMatchOperation(NMatchOperation.MatchMode.EXACT));
        this.operationCache.put("forAll", new ForAllOperation());
        this.operationCache.put("reject", new RejectOperation());
        this.operationCache.put("rejectOne", new RejectOneOperation());
        this.operationCache.put("select", new SelectOperation());
        this.operationCache.put("selectOne", new SelectOneOperation());
        this.operationCache.put("selectFirst", new SelectFirstOperation());
        this.operationCache.put("aggregate", new AggregateOperation());
        this.operationCache.put("closure", new ClosureOperation());
        this.operationCache.put("sortBy", new SortByOperation());
        this.operationCache.put("mapBy", new MapByOperation());
        this.operationCache.put("as", new AsOperation());
        this.operationCache.put("find", new FindOperation());
        this.operationCache.put("findOne", new FindOneOperation());
        this.operationCache.put("parallelCount", new ParallelCountOperation());
        this.operationCache.put("parallelSelect", new ParallelSelectOperation());
        this.operationCache.put("parallelSelectOne", new ParallelSelectOneOperation());
        this.operationCache.put("parallelReject", new ParallelRejectOperation());
        this.operationCache.put("parallelRejectOne", new ParallelRejectOneOperation());
        this.operationCache.put("parallelOne", new ParallelNMatchOperation(NMatchOperation.MatchMode.EXACT, 1));
        this.operationCache.put("parallelNone", new ParallelNMatchOperation(NMatchOperation.MatchMode.EXACT, 0));
        this.operationCache.put("parallelNMatch", new ParallelNMatchOperation(NMatchOperation.MatchMode.EXACT));
        this.operationCache.put("parallelAtMostNMatch", new ParallelNMatchOperation(NMatchOperation.MatchMode.MAXIMUM));
        this.operationCache.put("parallelAtLeastNMatch", new ParallelNMatchOperation(NMatchOperation.MatchMode.MINIMUM));
        this.operationCache.put("parallelExists", new ParallelExistsOperation());
        this.operationCache.put("parallelForAll", new ParallelForAllOperation());
        this.operationCache.put("parallelCollect", new ParallelCollectOperation());
        this.operationCache.put("parallelSortBy", new ParallelSortByOperation());
        this.operationCache.put("parallelMapBy", new ParallelMapByOperation());
        this.createCache();
    }

    @Deprecated
    protected void createCache() {
    }

    public AbstractOperation getOperationFor(String name) {
        return this.operationCache.get(name);
    }

    public AbstractOperation getOptimisedOperation(String name, Object target, IModel owningModel, IEolContext context) {
        AbstractOperation sequentialOp;
        AbstractOperation parallelOp;
        AbstractOperation originalOp = this.operationCache.get(name);
        if (this.isOverridenDelegate(originalOp)) {
            return originalOp;
        }
        if (originalOp != null && context instanceof IEolContextParallel && target instanceof Collection && ((IEolContextParallel)context).isParallelisationLegal() && !name.startsWith("parallel") && ((Collection)target).size() >= ((IEolContextParallel)context).getParallelism() && (parallelOp = this.operationCache.get("parallel" + StringUtil.firstToUpper((String)name))) != null) {
            return parallelOp;
        }
        if (originalOp == null && name.startsWith("sequential") && (sequentialOp = this.operationCache.get(StringUtil.firstToLower((String)name.substring(10)))) != null) {
            return sequentialOp;
        }
        return originalOp;
    }

    public boolean isOverridenDelegate(AbstractOperation operation) {
        if (operation instanceof DelegateBasedOperation) {
            Object delegate = ((DelegateBasedOperation)operation).getDelegateOperation();
            if (delegate == null) {
                return false;
            }
            Class<?> delegateClass = delegate.getClass();
            for (AbstractOperation op : this.operationCache.values()) {
                if (op.getClass() != delegateClass) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

