/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection.java;

import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.java.EnumObjectMethod;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;
import org.eclipse.epsilon.eol.types.EolNativeType;

public class JavaPropertyGetter
extends AbstractPropertyGetter {
    @Override
    public boolean hasProperty(Object object, String property, IEolContext context) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ObjectMethod om = this.getMethodFor(object, property, context);){
            boolean bl = om.getMethod() != null;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected ObjectMethod getMethodFor(Object object, String property, IEolContext context) {
        Class<?> clazz;
        OperationContributorRegistry registry = context.getOperationContributorRegistry();
        ObjectMethod om = registry.findContributedMethodForEvaluatedParameters(object, "get" + property, new Object[0], context);
        if (om != null) {
            return om;
        }
        om = registry.findContributedMethodForEvaluatedParameters(object, property, new Object[0], context);
        if (om != null) {
            return om;
        }
        om = registry.findContributedMethodForEvaluatedParameters(object, "is" + property, new Object[0], context);
        if (om != null) {
            return om;
        }
        if (object instanceof EolNativeType && (clazz = ((EolNativeType)object).getJavaClass()).isEnum()) {
            return new EnumObjectMethod(clazz, property);
        }
        return new ObjectMethod(object);
    }

    @Override
    public Object invoke(Object object, String property, IEolContext context) throws EolRuntimeException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ObjectMethod objectMethod = this.getMethodFor(object, property, context);){
            ModuleElement ast = context.getExecutorFactory().getActiveModuleElement();
            if (objectMethod.method == null) {
                throw new EolIllegalPropertyException(object, property, ast, context);
            }
            return objectMethod.execute(ast, context, new Object[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

