/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection;

import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.ExtendedPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.ExtendedPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.TuplePropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.TuplePropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolTuple;

public class IntrospectionManager {
    protected IPropertyGetter defaultPropertyGetter = new JavaPropertyGetter();
    protected IPropertySetter defaultPropertySetter = new JavaPropertySetter();

    public IPropertySetter getPropertySetterFor(Object instance, String property, IEolContext context) {
        if (property.startsWith("~")) {
            return new ExtendedPropertySetter();
        }
        if (instance instanceof EolTuple) {
            return new TuplePropertySetter();
        }
        IModel knowsModel = IntrospectionManager.getModelThatKnowsAboutProperty(instance, property, context);
        return knowsModel != null ? knowsModel.getPropertySetter() : this.defaultPropertySetter;
    }

    public IPropertyGetter getPropertyGetterFor(Object instance, String property, IEolContext context) {
        if (property.startsWith("~")) {
            return new ExtendedPropertyGetter();
        }
        if (instance instanceof EolTuple) {
            return new TuplePropertyGetter();
        }
        IModel knowsModel = IntrospectionManager.getModelThatKnowsAboutProperty(instance, property, context);
        return knowsModel != null ? knowsModel.getPropertyGetter() : this.defaultPropertyGetter;
    }

    public boolean isModelBasedProperty(Object instance, String property, IEolContext context) {
        return IntrospectionManager.getModelThatKnowsAboutProperty(instance, property, context) != null;
    }

    public static IModel getModelThatKnowsAboutProperty(Object instance, String property, IEolContext context) {
        for (IModel model : context.getModelRepository().getModels()) {
            if (!model.knowsAboutProperty(instance, property)) continue;
            return model;
        }
        return null;
    }

    public IPropertyGetter getDefaultPropertyGetter() {
        return this.defaultPropertyGetter;
    }

    public void setDefaultPropertyGetter(IPropertyGetter defaultPropertyGetter) {
        this.defaultPropertyGetter = defaultPropertyGetter;
    }

    public IPropertySetter getDefaultPropertySetter() {
        return this.defaultPropertySetter;
    }

    public void setDefaultPropertySetter(IPropertySetter defaultPropertySetter) {
        this.defaultPropertySetter = defaultPropertySetter;
    }
}

