/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context.concurrent;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Spliterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;
import org.eclipse.epsilon.common.concurrent.DelegatePersistentThreadLocal;
import org.eclipse.epsilon.common.concurrent.PersistentThreadLocal;
import org.eclipse.epsilon.common.function.BaseDelegate;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.concurrent.EolNestedParallelismException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.concurrent.EolThreadPoolExecutor;
import org.eclipse.epsilon.eol.execute.context.AsyncStatementInstance;
import org.eclipse.epsilon.eol.execute.context.EolContext;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;

public class EolContextParallel
extends EolContext
implements IEolContextParallel {
    int numThreads;
    boolean isInParallelTask;
    boolean isInShortCircuitTask;
    protected EolThreadPoolExecutor executorService;
    ThreadLocal<FrameStack> concurrentFrameStacks;
    ThreadLocal<ExecutorFactory> concurrentExecutorFactories;
    ThreadLocal<IEolContext> threadLocalShadows;

    public EolContextParallel() {
        this(0);
    }

    public EolContextParallel(int parallelism) {
        this.numThreads = parallelism > 0 ? parallelism : ConcurrencyUtils.DEFAULT_PARALLELISM;
        this.frameStack.setThreadSafe(true);
        this.asyncStatementsQueue = new ConcurrentLinkedQueue();
    }

    protected EolContextParallel(IEolContext other) {
        super(other);
        this.frameStack.setThreadSafe(true);
        if (other instanceof EolContextParallel) {
            this.executorService = ((EolContextParallel)other).getExecutorService();
        }
        if (other instanceof IEolContextParallel) {
            this.numThreads = ((IEolContextParallel)other).getParallelism();
        } else {
            this.numThreads = ConcurrencyUtils.DEFAULT_PARALLELISM;
            this.asyncStatementsQueue = new ConcurrentLinkedQueue<AsyncStatementInstance>(other.getAsyncStatementsQueue());
        }
    }

    protected void initThreadLocals() {
        this.concurrentFrameStacks = this.initDelegateThreadLocal(this::createThreadLocalFrameStack);
        this.concurrentExecutorFactories = this.initDelegateThreadLocal(this::createThreadLocalExecutorFactory);
        this.threadLocalShadows = ThreadLocal.withInitial(this::createShadowThreadLocalContext);
    }

    protected <T extends BaseDelegate<T>> DelegatePersistentThreadLocal<T> initDelegateThreadLocal(Supplier<? extends T> constructor) {
        return new DelegatePersistentThreadLocal(this.numThreads, constructor);
    }

    protected boolean useThreadLocalValue() {
        return this.isInParallelTask;
    }

    protected final <R> R parallelGet(ThreadLocal<? extends R> threadLocal, Supplier<? extends R> originalValueGetter) {
        return threadLocal != null && this.useThreadLocalValue() ? threadLocal.get() : originalValueGetter.get();
    }

    protected final <R> R parallelGet(ThreadLocal<? extends R> threadLocal, R originalValue) {
        return threadLocal != null && this.useThreadLocalValue() ? threadLocal.get() : originalValue;
    }

    protected final <T> void parallelSet(T value, ThreadLocal<? super T> threadLocal, Consumer<? super T> originalValueSetter) {
        if (threadLocal != null && this.useThreadLocalValue()) {
            threadLocal.set(value);
        } else {
            originalValueSetter.accept(value);
        }
    }

    protected void removeAll(ThreadLocal<?> ... threadLocals) {
        if (threadLocals != null) {
            ThreadLocal<?>[] threadLocalArray = threadLocals;
            int n = threadLocals.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadLocal<?> tl = threadLocalArray[n2];
                if (tl instanceof DelegatePersistentThreadLocal && !this.isInShortCircuitTask) {
                    ((DelegatePersistentThreadLocal)tl).removeAll(BaseDelegate.MergeMode.MERGE_INTO_BASE);
                } else if (tl instanceof PersistentThreadLocal) {
                    ((PersistentThreadLocal)tl).removeAll();
                } else if (tl != null) {
                    tl.remove();
                }
                ++n2;
            }
        }
    }

    protected synchronized void clearThreadLocals() {
        this.removeAll(this.concurrentFrameStacks, this.concurrentExecutorFactories, this.threadLocalShadows);
    }

    protected void nullifyThreadLocals() {
        this.concurrentFrameStacks = null;
        this.concurrentExecutorFactories = null;
        this.threadLocalShadows = null;
    }

    protected void clearExecutor() {
        if (this.executorService != null) {
            if (this.isInShortCircuitTask) {
                this.executorService.shutdownNow();
            } else {
                this.executorService.shutdown();
            }
            this.executorService = null;
        }
    }

    protected EolThreadPoolExecutor newExecutorService() {
        return new EolThreadPoolExecutor(this.numThreads);
    }

    @Override
    public synchronized ExecutorService beginParallelTask(ModuleElement entryPoint, boolean shortCircuiting) throws EolNestedParallelismException {
        this.ensureNotNested((ModuleElement)(entryPoint != null ? entryPoint : this.getModule()));
        this.isInShortCircuitTask = shortCircuiting;
        this.initThreadLocals();
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = this.newExecutorService();
        }
        this.isInParallelTask = true;
        return this.executorService;
    }

    @Override
    public synchronized void endParallelTask() throws EolRuntimeException {
        this.clearExecutor();
        this.clearThreadLocals();
        this.isInParallelTask = false;
        this.isInShortCircuitTask = false;
    }

    @Override
    public synchronized void setParallelism(int threads) throws IllegalStateException, IllegalArgumentException {
        if (threads != this.numThreads) {
            if (this.isInParallelTask) {
                throw new IllegalStateException("Cannot change parallelism whilst execution is in progress!");
            }
            if (threads <= 0) {
                throw new IllegalArgumentException("Parallelism of " + threads + " is nonsensical!");
            }
            this.numThreads = threads;
        }
    }

    @Override
    public boolean isParallel() {
        return this.isInParallelTask;
    }

    @Override
    public final int getParallelism() {
        return this.numThreads;
    }

    @Override
    public final synchronized EolThreadPoolExecutor getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.newExecutorService();
        }
        return this.executorService;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.clearExecutor();
        this.nullifyThreadLocals();
    }

    @Override
    public FrameStack getFrameStack() {
        return this.parallelGet(this.concurrentFrameStacks, this.frameStack);
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.parallelGet(this.concurrentExecutorFactories, this.executorFactory);
    }

    @Override
    public void setFrameStack(FrameStack frameStack) {
        this.parallelSet(frameStack, this.concurrentFrameStacks, fs -> {
            FrameStack frameStack = this.frameStack = fs;
        });
    }

    @Override
    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.parallelSet(executorFactory, this.concurrentExecutorFactories, ef -> {
            ExecutorFactory executorFactory = this.executorFactory = ef;
        });
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [parallelism=" + this.getParallelism() + ']';
    }

    protected ExecutorFactory createThreadLocalExecutorFactory() {
        return new ExecutorFactory(this.executorFactory);
    }

    protected FrameStack createThreadLocalFrameStack() {
        return new FrameStack(this.frameStack, false);
    }

    protected OperationContributorRegistry createThreadLocalOperationContributorRegistry() {
        return new OperationContributorRegistry();
    }

    protected IEolContext createShadowThreadLocalContext() {
        return new EolContext(this);
    }

    public IEolContext getShadow() {
        return !this.isInParallelTask || this.threadLocalShadows == null ? this : this.threadLocalShadows.get();
    }

    public static IEolContextParallel convertToParallel(IEolContext context) throws EolNestedParallelismException {
        if (context instanceof IEolContextParallel) {
            return (IEolContextParallel)context;
        }
        IModule cModule = context.getModule();
        if (cModule instanceof IEolModule && ((IEolModule)cModule).getContext() instanceof IEolContextParallel) {
            throw new EolNestedParallelismException("Attempted to create parallel context from a shadow!");
        }
        return new EolContextParallel(context);
    }

    public Object executeJob(Object job) throws EolRuntimeException {
        if (job == null) {
            return null;
        }
        if (job instanceof Iterable) {
            boolean isCollection = job instanceof Collection;
            if (this.isParallelisationLegal()) {
                AbstractList jobs = isCollection ? new ArrayList(((Collection)job).size()) : new LinkedList();
                for (Object next : (Iterable)job) {
                    jobs.add(() -> this.executeJob(next));
                }
                return this.executeAll(null, jobs);
            }
            AbstractList results = isCollection ? new ArrayList(((Collection)job).size()) : new LinkedList();
            for (Object next : (Iterable)job) {
                results.add(this.executeJob(next));
            }
            return results;
        }
        if (job instanceof ModuleElement) {
            return this.getExecutorFactory().execute((ModuleElement)job, this.getShadow());
        }
        if (job instanceof Object[]) {
            return this.executeJob(Arrays.asList((Object[])job));
        }
        if (job instanceof Stream) {
            Stream stream = (Stream)job;
            boolean finite = stream.spliterator().hasCharacteristics(64);
            return this.executeJob(finite ? stream.collect(Collectors.toList()) : stream.iterator());
        }
        if (job instanceof BaseStream) {
            return this.executeJob(((BaseStream)job).iterator());
        }
        if (job instanceof Spliterator) {
            return this.executeJob(StreamSupport.stream((Spliterator)job, this.isParallelisationLegal()));
        }
        if (job instanceof Iterator) {
            Iterable iter = () -> (Iterator)job;
            return this.executeJob(iter);
        }
        if (job instanceof Supplier) {
            return ((Supplier)job).get();
        }
        try {
            if (job instanceof Future) {
                return ((Future)job).get();
            }
            if (job instanceof Callable) {
                return ((Callable)job).call();
            }
        }
        catch (Exception ex) {
            EolRuntimeException.propagateDetailed(ex);
        }
        if (job instanceof Runnable) {
            ((Runnable)job).run();
            return null;
        }
        throw new IllegalArgumentException("Encountered unexpected object of type " + job.getClass().getName());
    }
}

