/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.Map;
import java.util.Objects;
import org.eclipse.epsilon.eol.exceptions.EolIllegalVariableAssignmentException;
import org.eclipse.epsilon.eol.exceptions.EolReadOnlyVariableException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolType;

public class Variable {
    protected String name = "";
    protected Object value;
    protected EolType type;
    protected boolean readOnly = false;
    protected String deprecationInfo;

    public static Variable createReadOnlyVariable(String name, Object value) {
        return new Variable(name, value, EolAnyType.Instance, true);
    }

    public static Variable createReadOnlyVariable(Map.Entry<String, ?> entry) {
        return Variable.createReadOnlyVariable(entry.getKey(), entry.getValue());
    }

    public Variable() {
    }

    public Variable(Map.Entry<String, ?> entry) {
        this(entry.getKey(), entry.getValue(), EolAnyType.Instance, false);
    }

    public Variable(String name, Object value, EolType type, boolean readOnly) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.readOnly = readOnly;
    }

    public void dispose() {
        this.type = null;
        this.value = null;
    }

    public Variable(String name, EolType type) {
        this.name = name;
        this.type = type;
    }

    public Variable(String name, Object value, EolType type) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public Variable(Variable v) {
        this(v.name, v.value, v.type, v.readOnly);
        this.deprecationInfo = v.deprecationInfo;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue, IEolContext context) throws EolRuntimeException {
        if (this.isReadOnly()) {
            throw new EolReadOnlyVariableException(this);
        }
        if (newValue != null && !this.getType().isKind(newValue)) {
            throw new EolIllegalVariableAssignmentException(this, this.getType(), newValue, context);
        }
        this.value = newValue;
    }

    public void setValueBruteForce(Object newValue) {
        this.value = newValue;
    }

    public void setType(EolType type) {
        this.type = type;
    }

    public EolType getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDeprecationInfo() {
        return this.deprecationInfo;
    }

    public void setDeprecationInfo(String deprecationInfo) {
        this.deprecationInfo = deprecationInfo;
    }

    public Variable clone() {
        return new Variable(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type) && Objects.equals(this.readOnly, other.readOnly);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public String toString() {
        return this.value + " " + this.type;
    }
}

