/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.ForStatement;
import org.eclipse.epsilon.eol.dom.WhileStatement;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.SingleFrame;
import org.eclipse.epsilon.eol.execute.context.Variable;

class FrameStackRegion
implements Cloneable {
    private Deque<SingleFrame> frames;

    public FrameStackRegion() {
        this(false);
    }

    public FrameStackRegion(boolean concurrent) {
        this.frames = concurrent ? new ConcurrentLinkedDeque() : new ArrayDeque();
    }

    public void clear() {
        for (Frame frame : this.frames) {
            frame.clear();
        }
    }

    public void dispose() {
        while (!this.isEmpty()) {
            this.disposeTopFrame();
        }
    }

    public Frame enter(FrameType type, ModuleElement entryPoint, Variable ... variables) {
        this.frames.push(new SingleFrame(type, entryPoint));
        this.put(variables);
        return this.top();
    }

    public Frame enter(FrameType type, ModuleElement entryPoint, Map<String, ?> variables) {
        return this.enter(type, entryPoint, FrameStackRegion.variableMapToArray(variables));
    }

    protected static Variable[] variableMapToArray(Map<String, ?> variablesMap) {
        return variablesMap == null ? new Variable[]{} : (Variable[])variablesMap.entrySet().stream().map(Variable::createReadOnlyVariable).toArray(Variable[]::new);
    }

    public int frameCount() {
        return this.frames.size();
    }

    public Variable get(String name) {
        for (Frame frame : this.frames) {
            Variable v = frame.get(name);
            if (v != null) {
                return v;
            }
            if (frame.isProtected()) break;
        }
        return null;
    }

    public Map<String, Variable> getAll() {
        HashMap<String, Variable> all = new HashMap<String, Variable>();
        for (Frame frame : this.frames) {
            for (Map.Entry<String, Variable> entry : frame.getAll().entrySet()) {
                String key = entry.getKey();
                if (all.containsKey(key)) continue;
                all.put(key, entry.getValue());
            }
            if (frame.isProtected()) break;
        }
        return all;
    }

    public boolean isEmpty() {
        return this.frames.isEmpty();
    }

    public boolean isInLoop() {
        for (SingleFrame frame : this.frames) {
            if (FrameStackRegion.isLoopAst(frame.getEntryPoint())) {
                return true;
            }
            if (!frame.isProtected()) continue;
            return false;
        }
        return false;
    }

    public void leave(ModuleElement entryPoint) {
        this.leave(entryPoint, true);
    }

    public void leave(ModuleElement entryPoint, boolean disposeFrameWithSpecifiedEntryPoint) {
        if (!this.isEmpty()) {
            this.disposeFramesUntil(entryPoint);
            if (disposeFrameWithSpecifiedEntryPoint) {
                this.disposeTopFrame();
            }
        }
    }

    public void put(String name, Object value) {
        Frame top = this.top();
        if (top != null) {
            top.put(name, value);
        }
    }

    public void put(Variable variable) {
        Frame top = this.top();
        if (top != null) {
            top.put(variable);
        }
    }

    public void put(Variable ... variables) {
        Frame top = this.top();
        if (top != null) {
            Variable[] variableArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable variable = variableArray[n2];
                top.put(variable);
                ++n2;
            }
        }
    }

    public void putAll(Map<String, Variable> variables) {
        Frame top = this.top();
        if (top != null) {
            top.putAll(variables);
        }
    }

    public void remove(String name) {
        for (Frame frame : this.frames) {
            frame.remove(name);
            if (frame.isProtected()) break;
        }
    }

    public Frame top() {
        return this.frames.peek();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (SingleFrame frame : this.frames) {
            result.append(frame.toString());
        }
        return result.toString();
    }

    static void mergeFrames(FrameStackRegion from, FrameStackRegion to) {
        if (from != null && to != null && from.frames != null) {
            AbstractCollection framesToAdd = to.isThreadSafe() ? new ConcurrentLinkedDeque() : new ArrayDeque();
            for (SingleFrame frame : from.frames) {
                if (frame.getAll().isEmpty()) continue;
                framesToAdd.add(frame);
            }
            to.frames = to.frames == null ? framesToAdd : (Deque)CollectionUtil.mergeCollectionsUnique(to.frames, (Collection)framesToAdd, to.isThreadSafe() ? ConcurrentLinkedDeque::new : ArrayDeque::new);
        }
    }

    protected FrameStackRegion clone() {
        try {
            FrameStackRegion clone = (FrameStackRegion)super.clone();
            clone.frames = this.isThreadSafe() ? new ConcurrentLinkedDeque() : new ArrayDeque(this.frames.size());
            for (SingleFrame frame : this.frames) {
                clone.frames.add(frame.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cnsx) {
            throw new RuntimeException(cnsx);
        }
    }

    boolean isThreadSafe() {
        return this.frames instanceof ConcurrentLinkedDeque;
    }

    void setThreadSafe(boolean concurrent) {
        if (this.isThreadSafe() != concurrent) {
            this.frames = concurrent ? new ConcurrentLinkedDeque<SingleFrame>(this.frames) : new ArrayDeque<SingleFrame>(this.frames);
        }
    }

    protected Collection<SingleFrame> getFrames() {
        return this.frames;
    }

    protected static boolean isLoopAst(ModuleElement ast) {
        return ast instanceof ForStatement || ast instanceof WhileStatement;
    }

    private void disposeFramesUntil(ModuleElement entryPoint) {
        while (this.top().getEntryPoint() != entryPoint) {
            this.disposeTopFrame();
        }
    }

    private void disposeTopFrame() {
        if (!this.frames.isEmpty()) {
            this.frames.pop().dispose();
        }
    }
}

