/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.AsyncStatementInstance;
import org.eclipse.epsilon.eol.execute.context.ExtendedProperties;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.introspection.IntrospectionManager;
import org.eclipse.epsilon.eol.execute.operations.EolOperationFactory;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolClasspathNativeTypeDelegate;
import org.eclipse.epsilon.eol.types.IToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.userinput.IUserInput;
import org.eclipse.epsilon.eol.userinput.JavaConsoleUserInput;

public class EolContext
implements IEolContext {
    protected IUserInput userInput;
    protected FrameStack frameStack;
    protected ModelRepository modelRepository;
    protected IntrospectionManager introspectionManager;
    protected ExecutorFactory executorFactory;
    protected EolOperationFactory operationFactory;
    protected PrettyPrinterManager prettyPrinterManager;
    protected PrintStream outputStream;
    protected PrintStream errorStream;
    protected PrintStream warningStream;
    protected IModule module;
    protected boolean profilingEnabled = false;
    protected boolean assertionsEnabled = true;
    protected ExtendedProperties extendedProperties;
    protected Queue<AsyncStatementInstance> asyncStatementsQueue;
    protected OperationContributorRegistry methodContributorRegistry;
    protected EolClasspathNativeTypeDelegate classpathNativeTypeDelegate;
    protected List<IToolNativeTypeDelegate> nativeTypeDelegates;
    Class<? extends IModule> expectedModuleType = IModule.class;

    public EolContext() {
        this.userInput = new JavaConsoleUserInput();
        this.frameStack = new FrameStack();
        this.modelRepository = new ModelRepository();
        this.introspectionManager = new IntrospectionManager();
        this.executorFactory = new ExecutorFactory();
        this.operationFactory = new EolOperationFactory();
        this.prettyPrinterManager = new PrettyPrinterManager();
        this.outputStream = System.out;
        this.errorStream = System.err;
        this.warningStream = System.out;
        this.extendedProperties = new ExtendedProperties();
        this.asyncStatementsQueue = new LinkedList<AsyncStatementInstance>();
        this.methodContributorRegistry = new OperationContributorRegistry();
        this.classpathNativeTypeDelegate = new EolClasspathNativeTypeDelegate();
        this.nativeTypeDelegates = CollectionUtil.asList((Object)this.classpathNativeTypeDelegate);
        try {
            this.expectedModuleType = this.getClass().getMethod("getModule", new Class[0]).getReturnType();
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    public EolContext(IEolContext other) {
        this.userInput = other.getUserInput();
        this.modelRepository = other.getModelRepository();
        this.introspectionManager = other.getIntrospectionManager();
        this.operationFactory = other.getOperationFactory();
        this.prettyPrinterManager = other.getPrettyPrinterManager();
        this.outputStream = other.getOutputStream();
        this.errorStream = other.getErrorStream();
        this.warningStream = other.getWarningStream();
        this.profilingEnabled = other.isProfilingEnabled();
        this.assertionsEnabled = other.isAssertionsEnabled();
        this.extendedProperties = other.getExtendedProperties();
        this.asyncStatementsQueue = other.getAsyncStatementsQueue();
        this.nativeTypeDelegates = other.getNativeTypeDelegates();
        this.methodContributorRegistry = other.getOperationContributorRegistry();
        this.frameStack = other.getFrameStack();
        this.executorFactory = other.getExecutorFactory();
        IModule otherModule = other.getModule();
        if (this.expectedModuleType.isInstance(otherModule)) {
            this.module = otherModule;
        }
        this.classpathNativeTypeDelegate = other instanceof EolContext ? ((EolContext)other).classpathNativeTypeDelegate : new EolClasspathNativeTypeDelegate(other.getClass().getClassLoader());
    }

    @Override
    public OperationContributorRegistry getOperationContributorRegistry() {
        return this.methodContributorRegistry;
    }

    @Override
    public PrintStream getWarningStream() {
        return this.warningStream;
    }

    @Override
    public void setWarningStream(PrintStream warningStream) {
        this.warningStream = warningStream;
    }

    @Override
    public boolean isAssertionsEnabled() {
        return this.assertionsEnabled;
    }

    @Override
    public void setAssertionsEnabled(boolean assertionsEnabled) {
        this.assertionsEnabled = assertionsEnabled;
    }

    @Override
    public PrettyPrinterManager getPrettyPrinterManager() {
        return this.prettyPrinterManager;
    }

    @Override
    public void setPrettyPrinterManager(PrettyPrinterManager prettyPrinterManager) {
        this.prettyPrinterManager = prettyPrinterManager;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public EolOperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    @Override
    public void setOperationFactory(EolOperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    @Override
    public ModelRepository getModelRepository() {
        return this.modelRepository;
    }

    @Override
    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    @Override
    public FrameStack getFrameStack() {
        return this.frameStack;
    }

    @Override
    public void setFrameStack(FrameStack frameStack) {
        this.frameStack = frameStack;
    }

    @Override
    public IntrospectionManager getIntrospectionManager() {
        return this.introspectionManager;
    }

    @Override
    public void setIntrospectionManager(IntrospectionManager introspectionManager) {
        this.introspectionManager = introspectionManager;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = errorStream;
    }

    @Override
    public void setModule(IModule module) {
        if (module != null && !this.expectedModuleType.isInstance(module)) {
            throw new IllegalArgumentException("Invalid module type: expected " + this.expectedModuleType.getName() + " but got " + module.getClass().getName());
        }
        this.module = module;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public void setUserInput(IUserInput userInput) {
        String userInputVarName = "UserInput";
        this.userInput = userInput;
        FrameStack fs = this.getFrameStack();
        Variable variable = fs.get(userInputVarName);
        if (variable == null) {
            variable = Variable.createReadOnlyVariable(userInputVarName, userInput);
            variable.setDeprecationInfo("Variable UserInput is deprecated. Use System.user instead.");
            fs.putGlobal(variable);
        } else {
            variable.setValueBruteForce(userInput);
        }
    }

    @Override
    public IUserInput getUserInput() {
        return this.userInput;
    }

    @Override
    public List<IToolNativeTypeDelegate> getNativeTypeDelegates() {
        return this.nativeTypeDelegates;
    }

    @Override
    public void setNativeTypeDelegates(List<IToolNativeTypeDelegate> nativeTypeDelegates) {
        this.nativeTypeDelegates = nativeTypeDelegates;
    }

    @Override
    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    @Override
    public void setProfilingEnabled(boolean profilingEnabled) {
        this.profilingEnabled = profilingEnabled;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.extendedProperties;
    }

    @Override
    public void setExtendedProperties(ExtendedProperties extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    @Override
    public void dispose() {
        this.executorFactory.dispose();
        this.extendedProperties.clear();
    }

    @Override
    public Queue<AsyncStatementInstance> getAsyncStatementsQueue() {
        return this.asyncStatementsQueue;
    }
}

