/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.concurrent;

import java.util.concurrent.ThreadFactory;
import org.eclipse.epsilon.eol.execute.concurrent.EolExecutorThread;

public class EolThreadFactory
implements ThreadFactory {
    protected int threadCount;
    protected final int maxThreads;
    protected final String namePrefix;

    protected EolThreadFactory(int threadLimit, String threadNamePrefix) {
        this.namePrefix = threadNamePrefix != null ? threadNamePrefix : "EOL-Worker";
        this.maxThreads = threadLimit;
    }

    @Override
    public EolExecutorThread newThread(Runnable target) {
        if (++this.threadCount > this.maxThreads) {
            throw new IllegalStateException("Exceeded maximum number of threads: " + this.maxThreads);
        }
        return new EolExecutorThread(target, String.valueOf(this.namePrefix) + this.threadCount);
    }
}

