/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.epsilon.common.function.BaseDelegate;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElement;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.flowcontrol.EolTerminationException;
import org.eclipse.epsilon.eol.execute.StackTraceManager;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.DefaultExecutionController;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.control.ExecutionProfiler;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;

public class ExecutorFactory
implements BaseDelegate<ExecutorFactory> {
    private ExecutionController executionController;
    private ModuleElement activeModuleElement;
    private Collection<IExecutionListener> executionListeners;
    private ExecutorFactory base;
    private StackTraceManager stackTraceManager;

    public ExecutorFactory() {
        this(null);
    }

    public ExecutorFactory(ExecutorFactory parent) {
        this.base = parent;
        this.executionController = new DefaultExecutionController();
        this.enableStackTraceManager();
    }

    public final void enableStackTraceManager() {
        this.stackTraceManager = new StackTraceManager();
    }

    public final void disableStackTraceManager() {
        this.stackTraceManager = null;
    }

    public final StackTraceManager getStackTraceManager() {
        return this.stackTraceManager;
    }

    public void addExecutionListener(IExecutionListener listener) {
        if (this.executionListeners == null) {
            this.executionListeners = new ArrayList<IExecutionListener>(1);
        }
        this.executionListeners.add(listener);
    }

    public Collection<IExecutionListener> getExecutionListeners() {
        return this.executionListeners == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.executionListeners);
    }

    public boolean removeExecutionListener(IExecutionListener listener) {
        return this.executionListeners != null && this.executionListeners.remove(listener);
    }

    public ExecutionController getExecutionController() {
        return this.executionController;
    }

    public void setExecutionController(ExecutionController executionController) {
        this.executionController = executionController;
    }

    public boolean isProfilingEnabled() {
        return this.executionController instanceof ExecutionProfiler;
    }

    protected void preExecute(ModuleElement moduleElement, IEolContext context) throws EolRuntimeException {
        this.activeModuleElement = moduleElement;
        if (this.executionController != null) {
            if (this.executionController.isTerminated()) {
                throw new EolTerminationException(moduleElement);
            }
            try {
                this.executionController.control(moduleElement, context);
            }
            catch (Exception ex) {
                throw new EolInternalException(ex);
            }
        }
        if (this.stackTraceManager != null) {
            this.stackTraceManager.stackTrace.push(moduleElement);
        }
        if (this.executionListeners != null) {
            for (IExecutionListener listener : this.executionListeners) {
                listener.aboutToExecute(moduleElement, context);
            }
        }
    }

    protected void postExecuteSuccess(ModuleElement moduleElement, Object result, IEolContext context) {
        if (this.executionListeners != null) {
            for (IExecutionListener listener : this.executionListeners) {
                listener.finishedExecuting(moduleElement, result, context);
            }
        }
        if (this.stackTraceManager != null) {
            this.stackTraceManager.stackTrace.pop();
        }
    }

    protected void postExecuteFailure(ModuleElement moduleElement, Exception ex, IEolContext context) throws EolRuntimeException {
        EolRuntimeException exception = null;
        if (ex instanceof EolRuntimeException) {
            EolRuntimeException eolEx = (EolRuntimeException)ex;
            if (eolEx.getAst() == null) {
                eolEx.setAst(moduleElement);
            }
            exception = eolEx;
        } else {
            exception = new EolInternalException(ex, moduleElement);
        }
        if (this.executionListeners != null) {
            for (IExecutionListener listener : this.executionListeners) {
                listener.finishedExecutingWithException(moduleElement, exception, context);
            }
        }
        throw exception;
    }

    protected void postExecuteFinally(ModuleElement moduleElement, IEolContext context) {
        if (this.executionController != null) {
            this.executionController.done(moduleElement, context);
        }
    }

    protected Object executeImpl(ModuleElement moduleElement, IEolContext context) throws Exception {
        if (moduleElement instanceof IExecutableModuleElement) {
            return ((IExecutableModuleElement)moduleElement).execute(context);
        }
        if (moduleElement instanceof EolModule) {
            return ((EolModule)moduleElement).executeImpl();
        }
        return null;
    }

    protected Object executeImpl(IExecutableModuleElementParameter moduleElement, IEolContext context, Object parameter) throws EolRuntimeException {
        return moduleElement.execute(context, parameter);
    }

    public final Object execute(ModuleElement moduleElement, IEolContext context) throws EolRuntimeException {
        if (moduleElement == null) {
            return null;
        }
        this.preExecute(moduleElement, context);
        Object result = null;
        try {
            try {
                result = this.executeImpl(moduleElement, context);
                this.postExecuteSuccess(moduleElement, result, context);
            }
            catch (Exception ex) {
                this.postExecuteFailure(moduleElement, ex, context);
                this.postExecuteFinally(moduleElement, context);
            }
        }
        finally {
            this.postExecuteFinally(moduleElement, context);
        }
        return result;
    }

    public final Object execute(IExecutableModuleElementParameter moduleElement, IEolContext context, Object parameter) throws EolRuntimeException {
        if (moduleElement == null) {
            return null;
        }
        this.preExecute(moduleElement, context);
        Object result = null;
        try {
            try {
                result = this.executeImpl(moduleElement, context, parameter);
                this.postExecuteSuccess(moduleElement, result, context);
            }
            catch (Exception ex) {
                this.postExecuteFailure(moduleElement, ex, context);
                this.postExecuteFinally(moduleElement, context);
            }
        }
        finally {
            this.postExecuteFinally(moduleElement, context);
        }
        return result;
    }

    public ModuleElement getActiveModuleElement() {
        return this.activeModuleElement;
    }

    public void setBase(ExecutorFactory parent) {
        this.base = parent;
    }

    public ExecutorFactory getBase() {
        return this.base;
    }

    public void merge(BaseDelegate.MergeMode mode) {
        this.mergeCollectionsUnique(ef -> ef.executionListeners, ArrayList::new, mode);
    }

    public void dispose() {
        this.activeModuleElement = null;
        if (this.stackTraceManager != null) {
            this.stackTraceManager.dispose();
        }
        if (this.executionController != null) {
            this.executionController.dispose();
        }
        if (this.executionListeners != null) {
            this.executionListeners.clear();
        }
    }
}

