/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.exceptions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EolRuntimeException
extends Exception {
    protected ModuleElement ast = null;
    protected String reason = "";
    protected String message = null;
    protected IEolContext context = null;

    public EolRuntimeException() {
    }

    public EolRuntimeException(String reason) {
        super(reason);
        this.reason = reason;
    }

    public EolRuntimeException(String reason, ModuleElement ast) {
        this(reason);
        this.ast = ast;
    }

    public EolRuntimeException(Throwable cause) {
        super(cause);
    }

    public EolRuntimeException(String reason, Throwable cause) {
        super(reason, cause);
    }

    public ModuleElement getAst() {
        return this.ast;
    }

    public void setAst(ModuleElement ast) {
        this.ast = ast;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getLine() {
        if (this.getAst() != null) {
            return this.getAst().getRegion().getStart().getLine();
        }
        return 0;
    }

    public int getColumn() {
        if (this.getAst() != null) {
            return this.getAst().getRegion().getStart().getColumn();
        }
        return 0;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            IEolContext context;
            this.message = this.getReason();
            if (this.message == null) {
                this.message = "Unknown reason";
            }
            if (this.ast != null && this.ast.getModule() instanceof IEolModule && (context = ((IEolModule)this.ast.getModule()).getContext()) != null) {
                this.message = String.valueOf(this.message) + "\r\n" + context.getExecutorFactory().getStackTraceManager().getStackTraceAsString();
            }
        }
        return this.message;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public static EolRuntimeException wrap(Throwable t) {
        if (t instanceof EolRuntimeException) {
            return (EolRuntimeException)t;
        }
        return new EolInternalException(t);
    }

    public static void propagate(Throwable t) throws EolRuntimeException {
        throw EolRuntimeException.wrap(t);
    }

    public static void propagateDetailed(Throwable t) throws EolRuntimeException {
        if (t instanceof EolRuntimeException) {
            throw (EolRuntimeException)t;
        }
        throw EolRuntimeException.findCause(t);
    }

    public static EolRuntimeException findCause(Throwable runtimeEx) {
        if (runtimeEx == null) {
            return null;
        }
        if (runtimeEx instanceof EolRuntimeException) {
            return (EolRuntimeException)runtimeEx;
        }
        EolRuntimeException result = EolRuntimeException.findCauseImpl(runtimeEx.getCause(), new HashSet<Throwable>());
        return result != null ? result : new EolRuntimeException(runtimeEx);
    }

    private static EolRuntimeException findCauseImpl(Throwable currentCause, Collection<Throwable> causes) {
        if (currentCause instanceof EolRuntimeException) {
            return (EolRuntimeException)currentCause;
        }
        if (currentCause != null) {
            if (causes.contains(currentCause)) {
                return new EolRuntimeException(currentCause);
            }
            causes.add(currentCause);
            return EolRuntimeException.findCauseImpl(currentCause.getCause(), causes);
        }
        return null;
    }
}

