/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.dom.TypeInitialiser;
import org.eclipse.epsilon.eol.exceptions.EolRedefinedVariableException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolType;

public class VariableDeclaration
extends TypeInitialiser {
    protected List<Expression> parameterExpressions = new ArrayList<Expression>();
    protected NameExpression nameExpression;
    protected boolean instantiate;
    protected boolean external;
    protected TypeExpression typeExpression;

    public VariableDeclaration() {
    }

    public VariableDeclaration(NameExpression nameExpression, TypeExpression typeExpression, boolean instantiate, Expression ... parameterExpressions) {
        this.nameExpression = nameExpression;
        this.typeExpression = typeExpression;
        this.instantiate = instantiate;
        Expression[] expressionArray = parameterExpressions;
        int n = parameterExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameterExpression = expressionArray[n2];
            this.parameterExpressions.add(parameterExpression);
            ++n2;
        }
    }

    public void build(AST cst, IModule module) {
        AST parametersAst;
        super.build(cst, module);
        this.nameExpression = (NameExpression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.instantiate = cst.getText().equalsIgnoreCase("new");
        this.external = cst.getText().equals("ext");
        AST typeExpressionAst = cst.getSecondChild();
        this.typeExpression = (TypeExpression)module.createAst(typeExpressionAst, (ModuleElement)this);
        if (this.typeExpression != null && (parametersAst = typeExpressionAst.getNextSibling()) != null) {
            for (AST parameterAst : parametersAst.getChildren()) {
                this.parameterExpressions.add((Expression)module.createAst(parameterAst, (ModuleElement)this));
            }
        }
    }

    @Override
    public Variable execute(IEolContext context) throws EolRuntimeException {
        Variable variable;
        FrameStack frameStack = context.getFrameStack();
        if (this.external && (variable = frameStack.get(this.getName())) != null) {
            return variable;
        }
        EolAnyType variableType = this.typeExpression == null ? EolAnyType.Instance : (EolType)context.getExecutorFactory().execute(this.typeExpression, context);
        variable = frameStack.getTopFrame().get(this.getName());
        if (variable != null && variable.getType() != variableType) {
            throw new EolRedefinedVariableException(this.getName(), this);
        }
        Object newInstance = this.initialiseType(variableType, this.parameterExpressions, context, this.instantiate);
        variable = new Variable(this.getName(), newInstance, variableType);
        frameStack.put(variable);
        return variable;
    }

    public String getName() {
        return this.nameExpression.getName();
    }

    public boolean isInstantiate() {
        return this.instantiate;
    }

    public void setInstantiate(boolean instantiate) {
        this.instantiate = instantiate;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public TypeExpression getTypeExpression() {
        return this.typeExpression;
    }

    public void setTypeExpression(TypeExpression typeExpression) {
        this.typeExpression = typeExpression;
    }

    public NameExpression getNameExpression() {
        return this.nameExpression;
    }

    public void setNameExpression(NameExpression nameExpression) {
        this.nameExpression = nameExpression;
    }

    public List<Expression> getParameterExpressions() {
        return this.parameterExpressions;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

