/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.StringLiteral;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolMapType;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolNativeType;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolTupleType;
import org.eclipse.epsilon.eol.types.EolType;

public class TypeExpression
extends Expression {
    protected EolType type = EolAnyType.Instance;
    protected String name;
    protected List<TypeExpression> parameterTypeExpressions = new ArrayList<TypeExpression>();
    protected StringLiteral nativeType;

    public TypeExpression() {
    }

    public TypeExpression(String typeName) {
        this.setName(typeName);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.setName(cst.getText());
        for (AST child : cst.getChildren()) {
            ModuleElement moduleElement = module.createAst(child, (ModuleElement)this);
            if (moduleElement instanceof TypeExpression) {
                this.parameterTypeExpressions.add((TypeExpression)moduleElement);
                continue;
            }
            if (!"Native".equals(this.name)) continue;
            this.nativeType = (StringLiteral)moduleElement;
        }
    }

    @Override
    public EolType execute(IEolContext context) throws EolRuntimeException {
        if (this.type instanceof EolCollectionType) {
            EolCollectionType collectionType = (EolCollectionType)this.type;
            if (this.parameterTypeExpressions.size() >= 1 && collectionType.getContentType() == EolAnyType.Instance) {
                collectionType.setContentType(this.parameterTypeExpressions.get(0).execute(context));
            }
        } else if (this.type instanceof EolMapType) {
            EolMapType mapType = (EolMapType)this.type;
            if (this.parameterTypeExpressions.size() >= 1 && mapType.getKeyType() == EolAnyType.Instance) {
                mapType.setKeyType(this.parameterTypeExpressions.get(0).execute(context));
            }
            if (this.parameterTypeExpressions.size() >= 2 && mapType.getValueType() == EolAnyType.Instance) {
                mapType.setValueType(this.parameterTypeExpressions.get(1).execute(context));
            }
        }
        if (this.type != null) {
            return this.type;
        }
        if ("Native".equals(this.getName())) {
            return new EolNativeType(this.nativeType, context);
        }
        try {
            return new EolModelElementType(this.name, context);
        }
        catch (EolModelElementTypeNotFoundException | EolModelNotFoundException ex) {
            throw new EolTypeNotFoundException(this.getName(), this);
        }
    }

    public String getName() {
        return this.name;
    }

    public static EolType getType(String name) {
        switch (name) {
            case "Integer": {
                return EolPrimitiveType.Integer;
            }
            case "Any": {
                return EolAnyType.Instance;
            }
            case "Boolean": {
                return EolPrimitiveType.Boolean;
            }
            case "String": {
                return EolPrimitiveType.String;
            }
            case "Real": {
                return EolPrimitiveType.Real;
            }
            case "Map": 
            case "ConcurrentMap": {
                return new EolMapType(name);
            }
            case "List": {
                name = "Sequence";
            }
            case "OrderedSet": 
            case "Bag": 
            case "Set": 
            case "Collection": 
            case "Sequence": 
            case "ConcurrentBag": 
            case "ConcurrentSet": {
                return new EolCollectionType(name);
            }
            case "Nothing": 
            case "None": {
                return EolNoType.Instance;
            }
            case "Tuple": {
                return new EolTupleType();
            }
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
        this.type = TypeExpression.getType(this.name);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.getName();
    }

    public List<TypeExpression> getParameterTypeExpressions() {
        return this.parameterTypeExpressions;
    }

    public StringLiteral getNativeType() {
        return this.nativeType;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

