/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolUserException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class ThrowStatement
extends Statement {
    protected Expression thrown;

    public ThrowStatement() {
    }

    public ThrowStatement(Expression thrown) {
        this.setThrown(thrown);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.thrown = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
    }

    @Override
    public Void execute(IEolContext context) throws EolRuntimeException {
        Object thrownObject = null;
        if (this.thrown != null) {
            thrownObject = context.getExecutorFactory().execute(this.thrown, context);
        }
        throw new EolUserException(thrownObject, (ModuleElement)this);
    }

    public Expression getThrown() {
        return this.thrown;
    }

    public void setThrown(Expression thrown) {
        this.thrown = thrown;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

