/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.OperatorExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.flowcontrol.EolTernaryException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class TernaryExpression
extends OperatorExpression {
    protected Expression thirdOperand;

    public TernaryExpression() {
    }

    public TernaryExpression(Expression condition, Expression rIfTrue, Expression rIfFalse) {
        super(condition, rIfTrue);
        this.thirdOperand = rIfFalse;
    }

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.thirdOperand = (Expression)module.createAst(cst.getFourthChild(), (ModuleElement)this);
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        ExecutorFactory executorFactory = context.getExecutorFactory();
        Object condition = executorFactory.execute(this.firstOperand, context);
        if (!(condition instanceof Boolean)) {
            throw new EolTernaryException(this.firstOperand, condition);
        }
        return executorFactory.execute((Boolean)condition != false ? this.secondOperand : this.thirdOperand, context);
    }

    public Expression getThirdOperand() {
        return this.thirdOperand;
    }

    public void setThirdOperand(Expression thirdOperand) {
        this.thirdOperand = thirdOperand;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

