/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Annotation;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class SimpleAnnotation
extends Annotation {
    protected String value;

    public SimpleAnnotation() {
    }

    public SimpleAnnotation(String value) {
        this.setValue(value);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        String text = cst.getText().substring(1).trim();
        if (text.indexOf(" ") > -1) {
            String[] parts = text.split(" ");
            this.name = parts[0];
            this.value = parts[1];
        } else {
            this.name = text;
        }
    }

    @Override
    public boolean hasValue() {
        return this.getValue() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getValue(IEolContext context) throws EolRuntimeException {
        return this.getValue();
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

