/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.Collection;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.FeatureCallExpression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.exceptions.EolNullPointerException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.types.EolSequence;

public class PropertyCallExpression
extends FeatureCallExpression {
    public PropertyCallExpression() {
    }

    public PropertyCallExpression(Expression targetExpression, NameExpression propertyNameExpression) {
        this.targetExpression = targetExpression;
        this.nameExpression = propertyNameExpression;
    }

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.targetExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.nameExpression = (NameExpression)module.createAst(cst.getSecondChild(), (ModuleElement)this);
    }

    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        return this.execute(context.getExecutorFactory().execute(this.targetExpression, context), this.nameExpression, context);
    }

    public Object execute(Object source, NameExpression propertyNameExpression, IEolContext context) throws EolRuntimeException {
        String propertyName = propertyNameExpression.getName();
        if (source == null) {
            if (this.isNullSafe()) {
                return null;
            }
            throw new EolNullPointerException(propertyName, propertyNameExpression);
        }
        IPropertyGetter getter = context.getIntrospectionManager().getPropertyGetterFor(source, propertyName, context);
        if (source instanceof Collection && !getter.hasProperty(source, propertyName, context)) {
            EolSequence<Object> results = new EolSequence<Object>();
            results.ensureCapacity(((Collection)source).size());
            for (Object content : (Collection)source) {
                results.add(context.getIntrospectionManager().getPropertyGetterFor(content, propertyName, context).invoke(content, propertyName, context));
            }
            return results;
        }
        try {
            return PropertyCallExpression.wrap(getter.invoke(source, propertyName, context));
        }
        catch (EolRuntimeException eox) {
            if (eox.getAst() == null) {
                eox.setAst(this);
            }
            throw eox;
        }
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

