/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolType;

public class Parameter
extends AbstractModuleElement {
    protected NameExpression nameExpression;
    protected TypeExpression typeExpression;
    protected EolType type;

    public Parameter() {
    }

    public Parameter(NameExpression nameExpression) {
        this.nameExpression = nameExpression;
    }

    public Parameter(NameExpression nameExpression, TypeExpression typeExpression) {
        this(nameExpression);
        this.typeExpression = typeExpression;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.nameExpression = (NameExpression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.typeExpression = (TypeExpression)module.createAst(cst.getSecondChild(), (ModuleElement)this);
    }

    public TypeExpression getTypeExpression() {
        return this.typeExpression;
    }

    public void setTypeExpression(TypeExpression typeExpression) {
        this.typeExpression = typeExpression;
    }

    public NameExpression getNameExpression() {
        return this.nameExpression;
    }

    public void setNameExpression(NameExpression nameExpression) {
        this.nameExpression = nameExpression;
    }

    public String getName() {
        return this.nameExpression.getName();
    }

    public String getTypeName() {
        if (this.typeExpression == null) {
            return "Any";
        }
        return this.typeExpression.getName();
    }

    public String toString() {
        return String.valueOf(this.getName()) + " : " + this.getTypeName();
    }

    public EolType getType(IEolContext context) throws EolRuntimeException {
        if (this.type == null) {
            this.type = this.typeExpression != null ? (EolType)context.getExecutorFactory().execute(this.typeExpression, context) : EolAnyType.Instance;
        }
        return this.type;
    }

    public void clearCache() {
        this.type = null;
    }

    public boolean isExplicitlyTyped() {
        return this.typeExpression != null;
    }

    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

