/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.OperatorExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class OrOperatorExpression
extends OperatorExpression {
    public OrOperatorExpression() {
    }

    public OrOperatorExpression(Expression firstOperand, Expression secondOperand) {
        super(firstOperand, secondOperand);
    }

    @Override
    public Boolean execute(IEolContext context) throws EolRuntimeException {
        ExecutorFactory executorFactory = context.getExecutorFactory();
        Object o1 = executorFactory.execute(this.firstOperand, context);
        if (o1 instanceof Boolean) {
            if (((Boolean)o1).booleanValue()) {
                return true;
            }
            Object o2 = executorFactory.execute(this.secondOperand, context);
            if (o2 instanceof Boolean) {
                return (Boolean)o2;
            }
        }
        throw new EolRuntimeException("Operator 'or' applies only to operands of type Boolean", this);
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

