/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.AndOperatorExpression;
import org.eclipse.epsilon.eol.dom.DivOperatorExpression;
import org.eclipse.epsilon.eol.dom.DoubleEqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.ElvisOperatorExpression;
import org.eclipse.epsilon.eol.dom.EqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.GreaterEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.GreaterThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.ImpliesOperatorExpression;
import org.eclipse.epsilon.eol.dom.LessEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.LessThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.MinusOperatorExpression;
import org.eclipse.epsilon.eol.dom.NegativeOperatorExpression;
import org.eclipse.epsilon.eol.dom.NotEqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.NotOperatorExpression;
import org.eclipse.epsilon.eol.dom.OperatorExpression;
import org.eclipse.epsilon.eol.dom.OrOperatorExpression;
import org.eclipse.epsilon.eol.dom.PlusOperatorExpression;
import org.eclipse.epsilon.eol.dom.PostfixOperatorExpression;
import org.eclipse.epsilon.eol.dom.TimesOperatorExpression;
import org.eclipse.epsilon.eol.dom.XorOperatorExpression;

public class OperatorExpressionFactory {
    public OperatorExpression createOperatorExpression(AST ast) {
        String operator;
        switch (operator = ast.getText()) {
            case "=": {
                return new EqualsOperatorExpression();
            }
            case "==": {
                return new DoubleEqualsOperatorExpression();
            }
            case "!=": 
            case "<>": {
                return new NotEqualsOperatorExpression();
            }
            case "+": {
                return new PlusOperatorExpression();
            }
            case "-": {
                return ast.getChildCount() == 2 ? new MinusOperatorExpression() : new NegativeOperatorExpression();
            }
            case "*": {
                return new TimesOperatorExpression();
            }
            case "/": {
                return new DivOperatorExpression();
            }
            case "<": {
                return new LessThanOperatorExpression();
            }
            case ">": {
                return new GreaterThanOperatorExpression();
            }
            case "<=": {
                return new LessEqualOperatorExpression();
            }
            case ">=": {
                return new GreaterEqualOperatorExpression();
            }
            case "and": {
                return new AndOperatorExpression();
            }
            case "or": {
                return new OrOperatorExpression();
            }
            case "not": {
                return new NotOperatorExpression();
            }
            case "xor": {
                return new XorOperatorExpression();
            }
            case "implies": {
                return new ImpliesOperatorExpression();
            }
            case "++": {
                return new PostfixOperatorExpression(true);
            }
            case "--": {
                return new PostfixOperatorExpression(false);
            }
            case "?:": {
                return new ElvisOperatorExpression();
            }
        }
        throw new IllegalStateException("Unknown operator: " + operator);
    }
}

