/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolType;

public class OperationList
extends ArrayList<Operation> {
    public Operation getOperation(String name) {
        return this.stream().filter(op -> op.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Operation getOperation(Object object, String name, List<?> parameters, IEolContext context) throws EolRuntimeException {
        Operation operation = this.getOperation(object, name, parameters, true, context);
        if (operation == null) {
            operation = this.getOperation(object, name, parameters, false, context);
        }
        return operation;
    }

    public Operation getOperation(Object object, String name, List<?> parameters, boolean ofTypeOnly, IEolContext context) throws EolRuntimeException {
        return this.getOperations(object, name, parameters, ofTypeOnly, context, true).stream().findFirst().orElse(null);
    }

    public Collection<Operation> getOperations(Object object, String name, List<?> parameters, boolean ofTypeOnly, IEolContext context) throws EolRuntimeException {
        return this.getOperations(object, name, parameters, ofTypeOnly, context, false);
    }

    public Collection<Operation> getOperations(Object object, String name, List<?> parameters, boolean ofTypeOnly, IEolContext context, boolean returnOne) throws EolRuntimeException {
        OperationList operations = new OperationList();
        for (Operation operation : this) {
            boolean correctContext;
            if (!operation.getName().equals(name) || operation.getFormalParameters().size() != parameters.size()) continue;
            EolType contextType = operation.getContextType(context);
            boolean bl = correctContext = ofTypeOnly ? contextType.isType(object) : contextType.isKind(object);
            if (!correctContext) continue;
            Iterator<Parameter> fpi = operation.getFormalParameters().iterator();
            boolean correctParameters = true;
            for (Object parameter : parameters) {
                Parameter formalParameter = fpi.next();
                if (ofTypeOnly) {
                    correctParameters = correctParameters && (formalParameter.getType(context).isType(parameter) || parameter == null);
                    continue;
                }
                boolean bl2 = correctParameters = correctParameters && (formalParameter.getType(context).isKind(parameter) || parameter == null);
            }
            if (!correctParameters) continue;
            operations.add(operation);
            if (returnOne) break;
        }
        return operations;
    }

    public Operation getOperation(Object source, NameExpression operationNameExpression, List<?> parameters, IEolContext context) throws EolRuntimeException {
        Operation operation = this.getOperation(source, operationNameExpression.getName(), parameters, true, context);
        if (operation == null) {
            operation = this.getOperation(source, operationNameExpression.getName(), parameters, false, context);
        }
        return operation;
    }
}

