/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.FeatureCallExpression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.dom.OperationList;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolUndefinedVariableException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.contributors.IOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.execute.operations.simple.SimpleOperation;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolUndefined;

public class OperationCallExpression
extends FeatureCallExpression {
    protected final ArrayList<Expression> parameterExpressions = new ArrayList(0);
    protected boolean contextless;

    public OperationCallExpression() {
        this(false);
    }

    public OperationCallExpression(boolean contextless) {
        this.contextless = contextless;
    }

    public OperationCallExpression(Expression targetExpression, NameExpression nameExpression, Expression ... parameterExpressions) {
        this.targetExpression = targetExpression;
        this.nameExpression = nameExpression;
        boolean bl = this.contextless = targetExpression == null;
        if (parameterExpressions != null) {
            this.parameterExpressions.ensureCapacity(parameterExpressions.length);
            Expression[] expressionArray = parameterExpressions;
            int n = parameterExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameterExpression = expressionArray[n2];
                this.parameterExpressions.add(parameterExpression);
                ++n2;
            }
        }
    }

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        AST parametersAst = null;
        if (!this.contextless) {
            this.targetExpression = (Expression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
            this.nameExpression = (NameExpression)module.createAst(cst.getSecondChild(), (ModuleElement)this);
            parametersAst = cst.getSecondChild().getFirstChild();
        } else {
            this.nameExpression = new NameExpression(cst.getText());
            this.nameExpression.setRegion(cst.getRegion());
            this.nameExpression.setUri(cst.getUri());
            this.nameExpression.setModule(cst.getModule());
            parametersAst = cst.getFirstChild();
        }
        List parametersChildren = parametersAst.getChildren();
        this.parameterExpressions.ensureCapacity(this.parameterExpressions.size() + parametersChildren.size());
        for (AST parameterAst : parametersChildren) {
            this.parameterExpressions.add((Expression)module.createAst(parameterAst, (ModuleElement)this));
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(IEolContext context) throws EolRuntimeException {
        Object targetObject;
        String operationName = this.nameExpression.getName();
        ExecutorFactory executorFactory = context.getExecutorFactory();
        if (!this.contextless) {
            try {
                targetObject = executorFactory.execute(this.targetExpression, context);
            }
            catch (EolIllegalPropertyException | EolUndefinedVariableException npe) {
                switch (operationName) {
                    default: {
                        throw npe;
                    }
                    case "ifUndefined": 
                    case "ifDefined": 
                    case "isUndefined": 
                    case "isDefined": 
                }
                targetObject = EolUndefined.INSTANCE;
            }
        } else {
            targetObject = EolNoType.NoInstance;
        }
        if (targetObject == null && this.isNullSafe()) {
            return null;
        }
        IModel owningModel = context.getModelRepository().getOwningModel(targetObject);
        AbstractOperation operation = this.getAbstractOperation(targetObject, operationName, owningModel, context);
        if (operation != null && !operation.isOverridable()) {
            return operation.execute(targetObject, this.nameExpression, new ArrayList<Parameter>(0), this.parameterExpressions, context);
        }
        OperationContributor operationContributor = null;
        ObjectMethod objectMethod = null;
        try {
            OperationList operations;
            Operation helper;
            if (targetObject instanceof IOperationContributorProvider) {
                operationContributor = ((IOperationContributorProvider)targetObject).getOperationContributor();
            } else if (owningModel != null && owningModel instanceof IOperationContributorProvider) {
                operationContributor = ((IOperationContributorProvider)((Object)owningModel)).getOperationContributor();
            }
            if (operationContributor != null) {
                objectMethod = operationContributor.findContributedMethodForUnevaluatedParameters(targetObject, operationName, this.parameterExpressions, context);
            }
            if (objectMethod == null) {
                objectMethod = context.getOperationContributorRegistry().findContributedMethodForUnevaluatedParameters(targetObject, operationName, this.parameterExpressions, context);
            }
            if (objectMethod != null) {
                Object object = OperationCallExpression.wrap(objectMethod.execute((ModuleElement)this.nameExpression, context, this.nameExpression));
                return object;
            }
            ArrayList<Object> parameterValues = new ArrayList<Object>(this.parameterExpressions.size());
            for (Expression parameter : this.parameterExpressions) {
                parameterValues.add(executorFactory.execute(parameter, context));
            }
            IModule module = context.getModule();
            if (module instanceof IEolModule && !this.isArrow() && (helper = (operations = ((IEolModule)module).getOperations()).getOperation(targetObject, this.nameExpression, parameterValues, context)) != null) {
                Object object = helper.execute(targetObject, parameterValues, context);
                return object;
            }
            Object[] parameterValuesArray = parameterValues.toArray();
            if (operationContributor != null) {
                objectMethod = operationContributor.findContributedMethodForEvaluatedParameters(targetObject, operationName, parameterValuesArray, context, true);
            }
            if (objectMethod == null) {
                objectMethod = context.getOperationContributorRegistry().findContributedMethodForEvaluatedParameters(targetObject, operationName, parameterValuesArray, context);
            }
            if (operationContributor != null && objectMethod == null) {
                objectMethod = operationContributor.findContributedMethodForEvaluatedParameters(targetObject, operationName, parameterValuesArray, context, false);
            }
            if (objectMethod != null) {
                Object object = OperationCallExpression.wrap(objectMethod.execute((ModuleElement)this.nameExpression, context, parameterValuesArray));
                return object;
            }
            if (operation instanceof SimpleOperation) {
                Object object = ((SimpleOperation)operation).execute(targetObject, parameterValues, context, this.nameExpression);
                return object;
            }
            if (operation == null) throw new EolIllegalOperationException(targetObject, operationName, this.nameExpression, context.getPrettyPrinterManager());
            if (targetObject == null) throw new EolIllegalOperationException(targetObject, operationName, this.nameExpression, context.getPrettyPrinterManager());
            if (this.parameterExpressions.isEmpty()) throw new EolIllegalOperationException(targetObject, operationName, this.nameExpression, context.getPrettyPrinterManager());
            Object object = operation.execute(targetObject, this.nameExpression, new ArrayList<Parameter>(0), this.parameterExpressions, context);
            return object;
        }
        finally {
            if (operationContributor != null) {
                operationContributor.close();
            }
            if (objectMethod != null) {
                objectMethod.close();
            }
        }
    }

    public void setContextless(boolean contextless) {
        this.contextless = contextless;
    }

    public boolean isContextless() {
        return this.contextless;
    }

    public List<Expression> getParameterExpressions() {
        return this.parameterExpressions;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

