/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.AnnotatableModuleElement;
import org.eclipse.epsilon.eol.dom.Annotation;
import org.eclipse.epsilon.eol.dom.ExecutableAnnotation;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.contributors.IterableOperationContributor;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolType;

public class Operation
extends AnnotatableModuleElement {
    protected NameExpression nameExpression;
    protected TypeExpression contextTypeExpression;
    protected TypeExpression returnTypeExpression;
    protected EolType contextType;
    protected EolType returnType;
    protected StatementBlock body;
    protected List<Parameter> formalParameters;
    protected boolean isCached;
    protected Map<Object, Object> cache;

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        AST nameAst = null;
        if (cst.getFirstChild().getType() == 70) {
            AST contextTypeExpressionAst = cst.getFirstChild();
            this.contextTypeExpression = (TypeExpression)module.createAst(contextTypeExpressionAst, (ModuleElement)this);
            nameAst = contextTypeExpressionAst.getNextSibling();
        } else {
            nameAst = cst.getFirstChild();
        }
        AST paramListAst = null;
        AST returnAst = null;
        AST bodyAst = null;
        if (nameAst.getNextSibling().getType() == 29) {
            paramListAst = nameAst.getNextSibling();
        }
        if (paramListAst != null) {
            if (paramListAst.getNextSibling().getType() == 70) {
                returnAst = paramListAst.getNextSibling();
                bodyAst = returnAst.getNextSibling();
            } else {
                bodyAst = paramListAst.getNextSibling();
            }
        } else if (nameAst.getNextSibling().getType() == 70) {
            returnAst = nameAst.getNextSibling();
            bodyAst = returnAst.getNextSibling();
        } else {
            bodyAst = nameAst.getNextSibling();
        }
        this.nameExpression = (NameExpression)module.createAst(nameAst, (ModuleElement)this);
        this.returnTypeExpression = (TypeExpression)module.createAst(returnAst, (ModuleElement)this);
        this.body = (StatementBlock)module.createAst(bodyAst, (ModuleElement)this);
        if (paramListAst != null) {
            List paramListAstChildren = paramListAst.getChildren();
            this.formalParameters = new ArrayList<Parameter>(paramListAstChildren.size());
            for (AST formalParameterAst : paramListAst.getChildren()) {
                this.formalParameters.add((Parameter)module.createAst(formalParameterAst, (ModuleElement)this));
            }
        } else {
            this.formalParameters = Collections.emptyList();
        }
        if (this.isCached = this.hasAnnotation("cached") && this.formalParameters.isEmpty()) {
            this.cache = Collections.synchronizedMap(new WeakHashMap());
        }
    }

    public void clearCache() {
        if (this.isCached()) {
            this.cache.clear();
        }
        this.returnType = null;
        this.contextType = null;
        for (Parameter formalParameter : this.formalParameters) {
            formalParameter.clearCache();
        }
    }

    public String toString() {
        String contextTypeName = "";
        String returnTypeName = "";
        if (this.contextTypeExpression != null) {
            contextTypeName = " - " + this.contextTypeExpression.getName();
        }
        if (this.returnTypeExpression != null) {
            returnTypeName = " : " + this.returnTypeExpression.getName();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (IterableOperationContributor ioc = new IterableOperationContributor(this.formalParameters);){
            return String.valueOf(this.getName()) + "(" + ioc.concat(", ") + ")" + returnTypeName + contextTypeName;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean isCached() {
        return this.isCached;
    }

    public Object execute(Object self, List<?> parameterValues, IEolContext context) throws EolRuntimeException {
        return this.execute(self, parameterValues, context, true);
    }

    public Object execute(Object self, List<?> parameterValues, IEolContext context, boolean inNewStackFrame) throws EolRuntimeException {
        boolean cacheContainsSelf;
        int paramSize = this.formalParameters.size();
        assert (paramSize <= 0 || paramSize == parameterValues.size());
        boolean bl = cacheContainsSelf = this.isCached && this.cache.containsKey(self);
        if (cacheContainsSelf) {
            return this.cache.get(self);
        }
        FrameStack scope = context.getFrameStack();
        if (inNewStackFrame) {
            scope.enterLocal(FrameType.PROTECTED, (ModuleElement)this, Variable.createReadOnlyVariable("self", self));
        }
        Iterator<?> parameterValuesIter = parameterValues.iterator();
        for (Parameter fp : this.formalParameters) {
            scope.put(new Variable(fp.getName(), parameterValuesIter.next(), fp.getType(context)));
        }
        this.evaluatePreConditions(context);
        Object result = Return.getValue(this.executeBody(context));
        this.checkResultType(result, context);
        this.evaluatePostConditions(context, result);
        if (inNewStackFrame) {
            scope.leaveLocal((ModuleElement)this);
        }
        if (this.isCached && !cacheContainsSelf) {
            this.cache.put(self, result);
        }
        return result;
    }

    protected Object executeBody(IEolContext context) throws EolRuntimeException {
        return context.getExecutorFactory().execute(this.getBody(), context);
    }

    protected void evaluatePreConditions(IEolContext context) throws EolRuntimeException {
        for (Annotation annotation : this.getAnnotations("pre")) {
            if (!(annotation instanceof ExecutableAnnotation)) continue;
            Object satisfied = ((ExecutableAnnotation)annotation).getValue(context);
            if (satisfied instanceof Boolean) {
                if (((Boolean)satisfied).booleanValue()) continue;
                throw new EolRuntimeException("Pre-condition not satisfied", (ModuleElement)annotation);
            }
            throw new EolIllegalReturnException("Boolean", satisfied, (ModuleElement)annotation, context);
        }
    }

    protected void checkResultType(Object result, IEolContext context) throws EolRuntimeException {
        if (this.returnTypeExpression != null && result != null) {
            if (this.returnType == null) {
                this.returnType = (EolType)context.getExecutorFactory().execute(this.returnTypeExpression, context);
            }
            if (!this.returnType.isKind(result)) {
                throw new EolRuntimeException(String.valueOf(this.getName()) + " is expected to return a " + this.returnType.getName() + ", but returned a " + result.getClass().getCanonicalName());
            }
        }
    }

    protected void evaluatePostConditions(IEolContext context, Object result) throws EolRuntimeException {
        FrameStack frameStack = context.getFrameStack();
        frameStack.put(Variable.createReadOnlyVariable("_result", result));
        for (Annotation annotation : this.getAnnotations("post")) {
            if (!(annotation instanceof ExecutableAnnotation)) continue;
            Object satisfied = ((ExecutableAnnotation)annotation).getValue(context);
            if (satisfied instanceof Boolean) {
                if (((Boolean)satisfied).booleanValue()) continue;
                throw new EolRuntimeException("Post-condition not satisfied: _result was " + context.getPrettyPrinterManager().print(result));
            }
            throw new EolIllegalReturnException("Boolean", satisfied, (ModuleElement)annotation, context);
        }
    }

    public EolType getReturnType(IEolContext context) throws EolRuntimeException {
        if (this.returnType == null) {
            this.returnType = this.returnTypeExpression != null ? (EolType)context.getExecutorFactory().execute(this.returnTypeExpression, context) : EolAnyType.Instance;
        }
        return this.returnType;
    }

    public EolType getContextType(IEolContext context) throws EolRuntimeException {
        if (this.contextType == null) {
            this.contextType = this.contextTypeExpression != null ? (EolType)context.getExecutorFactory().execute(this.contextTypeExpression, context) : EolNoType.Instance;
        }
        return this.contextType;
    }

    public String getName() {
        return this.nameExpression.getName();
    }

    public List<Parameter> getFormalParameters() {
        return this.formalParameters;
    }

    public StatementBlock getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    public NameExpression getNameExpression() {
        return this.nameExpression;
    }

    public void setNameExpression(NameExpression nameExpression) {
        this.nameExpression = nameExpression;
    }

    public TypeExpression getContextTypeExpression() {
        return this.contextTypeExpression;
    }

    public void setContextTypeExpression(TypeExpression contextTypeExpression) {
        this.contextTypeExpression = contextTypeExpression;
    }

    public TypeExpression getReturnTypeExpression() {
        return this.returnTypeExpression;
    }

    public void setReturnTypeExpression(TypeExpression returnTypeExpression) {
        this.returnTypeExpression = returnTypeExpression;
    }

    @Override
    public void accept(IEolVisitor visitor) {
        visitor.visit(this);
    }
}

